#!/bin/sh 
#
# ===================================================================
# M Goossens, S Rahtz. June 10 1995. revised December 5th 1995, March 1997
#
# Given a multiple master font, and values for up to 4 design space
# variables (how many, depends on the font), create AFM instances by 
# creating normalized weight factors, and applying them to the master 
# AFM files.
#
# Procedure:
#  1. create small PS file to invoke MM operators in PostScript
#     with right values
#  2. run GhostScript on file to derive normalized weights
#  3. run mmafm program to read master AFM files and write new one
#  4. write map entry and .pro header file
# ===================================================================
#echo "usage makeinstance fontname instancename design-space-variables 1 to 4"
X=$2.control
cat > $$.instance <<FOOBAR
/myfile (myfile) (w) file def
/str 20 string def            
/MASTERFONT findfont dup begin [
V1 V2 V3 V4 NormalizeDesignVector ConvertDesignVector
counttomark 1 sub -1 0 {
index str cvs myfile exch writestring 
myfile (\n) writestring} for
myfile closefile
] end 
FOOBAR
#-----------------------------------
MASTERFONT="$1"
V1="$3"
V2="$4"
V3="$5"
V4="$6"
sed -e "s/MASTERFONT/$MASTERFONT/" \
    -e "s/V1/$V1/" \
    -e "s/V2/$V2/" \
    -e "s/V3/$V3/" \
    -e "s/V4/$V4/" \
    < $$.instance > $$.ps
rm $$.instance
gs -dNODISPLAY `kpsewhich -format=.pfa $1.PFA` $$.ps quit.ps 
rm $$.ps
#----------------------------------
#
# build control file for mmafm
#
#----------------------------------
# number of weights
wc -l myfile | awk '{print $1}'  > $X 
# master AFM file names
cat $1.afmnames >> $X
# new name
echo $2 >> $X
# weights
cat myfile >> $X
#----------------------------------
rm myfile
mmafm $X | \
 sed -e "/^FontName/s/^FontName .*$/FontName $1-$3-$4-$5-$6/" \
     -e "/^FontName/s/-*$//" > $2.afm 
#----------------------------------
echo "/$2 /$1 findfont dup begin [" > $2.pro
echo "   $V1 $V2 $V3 $V4  NormalizeDesignVector ConvertDesignVector" >>$2.pro
echo "       ] end makeblendedfont definefont pop " >>$2.pro
#----------------------------------
exit

