/* error.c 2.9.0 92/07/06 -- print error message -- part of argloop */

#include "stdc.h"
#include "xstdio.h"
#include "argloop.h"
#include "fatal.h"

#ifndef __STDC__
#include <varargs.h>

int vfprintf ARGS((FILE *, const char *, va_list));

extern int errno, sys_nerr;
extern const char *sys_errlist[];

void NONRETURNING exit ARGS((int));
#ifndef NDEBUG
extern NONRETURNING void abort ARGS((void));
#  define EXIT(x) abort()
#else
#  define EXIT(x) exit(x)
#endif

inline void
verrorf(fmt, args)
     const char *fmt;
     va_list args;     
{
  if (progname && *progname) fprintf(stderr, "%s: ", progname);
  vfprintf(stderr, fmt, args);
  putc('.', stderr);
  putc('\n', stderr);
}

inline void
vperrorf(fmt, args)
     const char *fmt;
     va_list args;
{
  if (progname && *progname) fprintf(stderr, "%s: ", progname);
  vfprintf(stderr, fmt, args);
  if (errno > 0 && errno < sys_nerr)
    fprintf(stderr, ": %s.\n", sys_errlist[errno]);
  else if (errno != 0)
    fprintf(stderr, ", errno = %d.\n", errno);
  else
    fprintf(stderr, ".\n");
}

void
perrorf(va_alist)
     va_dcl
{
  va_list args;
  const char *fmt;
  
  va_start(args);
  fmt = va_arg(args, const char *);
  vperrorf(fmt, args);
  va_end(args);
}

void
errorf(va_alist)
     va_dcl
{
  va_list args;
  const char *fmt;
  
  va_start(args);
  fmt = va_arg(args, const char *);
  verrorf(fmt, args);
  fprintf(stderr, ".\n")
  va_end(args);
}

void NONRETURNING
pfatalf(va_alist)
     va_dcl
{
  va_list args;
  const char *fmt;
  
  va_start(args);
  fmt = va_arg(args, const char *);
  vperrorf(fmt, args);
  va_end(args);
  EXIT(1);
}

void NONRETURNING
fatalf(va_alist)
     va_dcl
{
  va_list args;
  const char *fmt;
  
  va_start(args);
  fmt = va_arg(args, const char *);
  verrorf(fmt, args);
  va_end(args);
  EXIT(1);
}

void NONRETURNING
syntaxf(va_alist)
     va_dcl
{
  va_list args;
  const char *fmt;
  
  va_start(args);
  fmt = va_arg(args, const char *);
  verrorf(fmt, args);
  va_end(args);
  putc('\n', stderr);
  EXIT(2);
}

#else
#include <stdarg.h>

int vfprintf ARGS((FILE *, const char *, va_list));

extern int errno, sys_nerr;
extern const char *sys_errlist[];

void NONRETURNING exit ARGS((int));
#ifndef NDEBUG
extern NONRETURNING void abort ARGS((void));
#  define EXIT(x) abort()
#else
#  define EXIT(x) exit(x)
#endif

inline void
verrorf(fmt, args)
     const char *fmt;
     va_list args;     
{
  if (progname && *progname) fprintf(stderr, "%s: ", progname);
  vfprintf(stderr, fmt, args);
  putc('.', stderr);
  putc('\n', stderr);
}

inline void
vperrorf(fmt, args)
     const char *fmt;
     va_list args;
{
  if (progname && *progname) fprintf(stderr, "%s: ", progname);
  vfprintf(stderr, fmt, args);
  if (errno > 0 && errno < sys_nerr)
    fprintf(stderr, ": %s.\n", sys_errlist[errno]);
  else if (errno != 0)
    fprintf(stderr, ", errno = %d.\n", errno);
  else
    fprintf(stderr, ".\n");
}

void
perrorf(const char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vperrorf(fmt, args);
  va_end(args);
}

void
errorf(const char *fmt, ...)
{
  va_list args;
  
  va_start(args, fmt);
  verrorf(fmt, args);
  fprintf(stderr, ".\n")
  va_end(args);
}

void NONRETURNING
pfatalf(const char *fmt, ...)
{
  va_list args;
  
  va_start(args, fmt);
  vperrorf(fmt, args);
  va_end(args);
  EXIT(1);
}

void NONRETURNING
fatalf(const char *fmt, ...)
{
  va_list args;
  
  va_start(args, fmt);
  verrorf(fmt, args);
  va_end(args);
  EXIT(1);
}

void NONRETURNING
syntaxf(const char *fmt, ...)
{
  va_list args;
  
  va_start(args, fmt);
  verrorf(fmt, args);
  va_end(args);
  putc('\n', stderr);
  EXIT(2);
}

#endif
