import java.awt.*;
import java.awt.event.*;

/**
 Dialog window to display at startup.  Give the user the option of opening
 a previously opened file or starting a new file.
 */
public class StartDialog extends Dialog implements ActionListener, ItemListener {
    // variables
    List m_List; // storage for files to open
    Checkbox m_NewFile, m_OldFile; // checkbox that is true if loading a new file
    String m_FileName; // name of file selected
    FileDialog m_FileDialog; // file dialog to use for new files

    StartDialog(Frame f, String name) {
        super(f, name, true);
        m_FileDialog = new FileDialog(f, "New BibTeX Database", FileDialog.SAVE);
        // list in center
        m_List = new List();
        m_List.addActionListener(this);
        m_List.addItemListener(this);
        add(m_List, "Center");
        // add panel with buttons and controls
        Panel pan = new Panel(new GridLayout(0,2));
        CheckboxGroup cbg = new CheckboxGroup();
        m_OldFile = new Checkbox("Open listed file", cbg, false);
        pan.add(m_OldFile);
        m_NewFile = new Checkbox("Open new or unlisted file", cbg, true);
        pan.add(m_NewFile);
        Button but = new Button("Continue");
        but.addActionListener(this);
        pan.add(but);
        but = new Button("Cancel");
        but.addActionListener(this);
        pan.add(but);
        add(pan, "South");
        pack();
        center(f);
    }

    /*
     ** center(Container over) centers the dialog over the passed
     ** container
     */
    public void center(Container over)
    {
        if(over.isVisible())
        {
            int width = getSize().width;
            int height = getSize().height;
            setSize(width, height);
            int parentScreenX = over.getLocationOnScreen().x;
            int parentScreenY = over.getLocationOnScreen().y;
            int parentWidth = over.getBounds().width;
            int parentHeight = over.getBounds().height;
            int screenX = Math.max(0, parentScreenX + parentWidth / 2 - width / 2);
            int screenY = Math.max(0, parentScreenY + parentHeight / 2 - height / 2);
            setLocation(screenX, screenY);
        }
    }

    /**
     Process action events.
     */
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        // look for cancel button
        if(cmd.equals("Cancel")) {
            m_FileName = null;
            setVisible(false);}
        if(cmd.equals("Continue")) {
            // check to see what we are pursuing
            if(m_NewFile.getState()) {
                // want to open a new file, load the file dialog
//                FileDialog m_FileDialog
                m_FileDialog.setVisible(true);
                if(m_FileDialog.getFile() != null) {
                    m_FileName = m_FileDialog.getDirectory() + m_FileDialog.getFile();}
                else {
                    m_FileName = null;}}
            else {
                // not a new file, check if anything selected on list
                if(m_List.getSelectedItem() != null) {
                    m_FileName = m_List.getSelectedItem();}
                else {
                    m_FileName = null;}}
            // done getting file name, hide and return control
            setVisible(false);}
        // further commands must be double clicks from list
        if(!cmd.equals("Cancel")
           && !cmd.equals("Continue")) {
            m_FileName = cmd;
            setVisible(false);}
    }

    /**
     Add an item to a list component alphabetically
     */
    private void addItemByOrder(List li, String item) {
        // add the choices alphabetically
        if(li.getItemCount() > 0) {
            int pos = 0;
            while(pos < li.getItemCount()) {
                if(li.getItem(pos).compareTo(item) > 0) {
                    li.addItem(item, pos);
                    break;}
                pos++;}
            if(pos == li.getItemCount()) {
                li.addItem(item);}}
        else {
            li.addItem(item);}
    }

    /**
     Set the options for files to load.  The file names are passed as
     an array of strings.
     */
    public void setFileOptions(String[] options) {
        // clear the list
        m_List.removeAll();
        // add the passed items
        if(options != null) {
            if(options.length > 0) {
                for(int i=0; i<options.length; i++) {
                    if(options[i] == null) break;
                    m_List.addItem(options[i]);}}}
        // all done
    }

    /**
     Process item events
     */
    public void itemStateChanged(ItemEvent evt) {
        // if an item was clicked on, switch the radio to indicate
        // that we will try to read one of the existing files
        m_OldFile.setState(true);
        validate();
//        System.out.println(evt.toString());
    }

    /**
     Return the name of the file that is to be opened.
     */
    public String getFileName() {
        return m_FileName;
    }
}

