use strict;
use warnings;
use Test::More tests => 68;
use Digest::BMW qw(bmw_384 bmw_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BMW->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(bmw_384_hex($data), $digest, "bmw_384_hex: $len bits of $msg");
        ok(
            bmw_384($data) eq pack('H*', $digest),
            "bmw_384: $len bits of $msg"
        );
    }

    my $md = Digest::BMW->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|1DB2643911391720E712A8C24457EE456FABFD555F479156E4B24278D6F6BCFB03FAB1EC2A2626B79F2880216BC29B29
00|F5ED7792E788BB547BC6781FC436BF288B61940237AE1C2DE32A5363528E43F84840B4F17A0AF60A7B94AE179995B574
C0|D3536E09DFC56D62CC49C46788ED85871F2CBD487468BD4D68D294E3623D61E78C1FC37BE5C1F2EDBE7B0E34C8259123
C0|10748F199E2FD1D97909D55611E8C9FBFF3B568E6A2A5E4E3C68892E761A7C32E20467014ED597D0CE3006523890FBE3
80|F506D693CC09E4CCE2BEE039D0E6E58D09F7B3DB154D5B53D021113FC27FD4FE286281654B01C73D50D44788FC3557D9
48|4B26BE1CB5661EAB04606535591DBF7EFF52C8651AD4DCE063C8FE61D7E3E6285009C287AAF7EFB4D1D1968FC919AE16
50|17AEB2D5C13E0CB2002F2CC80748F0500445BD4064E4C4A35A9A99ABFC4F95E3B98C9FE696BDC298F314B717D295C7B0
98|913AE66C810B757AFF16EE7A03B4934DEC3C2501DBACA29A0CDF23330C06711861DE33635D296D6501D505EFAB862697
CC|45D80A7A71B2437242BF0F856A02D4520FFDC3A40C7494BFAD67D696F4931A8664605A92B403511208D8FBE0BAFDE746
9800|22366F98CD88497F4F8532E6E0B8E738FB1560F4F1BEE6B0F87314BDF6B64B7E49F10DDE0304705ADBCDDF43E314656C
9D40|5462BBB2A5C18F969148E762D15F59EB2AE0C27E6EC03128B41D4289196F8C99948FBBE71F98406534AFC3D8CA4287F5
AA80|0E0A2B886F9918A48220EE93CCD1627E19D9BCC4B0C626B67F5E8E042667551B65FAD8FA654FDD0507288D253ADBA4E5
9830|FD012D531BF183B7896AFED609E03FB10427BAC9CDA70C15CB2CF693111987F3FDEBC53D9E72C2369BC806C15969FA24
5030|D0F3721F4622ECE81D37B9E060F2E51B24E57F74306BD3FDD32C38E8A217AE9826E39E7374C5848865014EB07DFD7D72
4D24|0387FF96C4A8B1EC317281F15C8BEB9054297988C74EF90E8451A1E42AD4B3BFF22BBCF09A7B7F7F27D636440B31ED02
CBDE|259FAA5DE410C8CD8F9868C5387430819901325445B2414199AC3C81E8FBB401C38206590C45A0A9FCD88BE5490FA7B3
41FB|58FF1CF0DC7AF1F52766410F56BFE6CEF7D0BD41285CCA5991990D654EABAB89EB728E3272E7551A66C609C56D6A0B8A
4FF400|E93634CB1C9ECAC10DB10FCB639E2A333FE827ED6DB78EC1F62448C40904A63D205B5BD2262661E27D068A73BA40C45A
FD0440|53BB5592C6A16BEC187DFC06B2C9F7FADEC62402B073F54726A0A50971A9A3960B563563892134951D4E52F8C15F1F41
424D00|53720B437322DFDD462C8D52AB2B91FC61D7B6C51209D47690F5E145BFABDCEFC2B0FD013E0BB6856687716013ED722A
3FDEE0|8E332A6D055FB7C183F6C861341FDB9AA0085DF9AD457C7F20D6CEE9EE5131138D05A5543AA90238B737B46CB84E5584
335768|0BC8FF891A9AC7F6E9EA548EA184EDA194D5AB71A4A4FF6AD567D54FE3573F60C8C4172E16DA994F626897FAC0E48B88
051E7C|46B6D7B94650E71561393FCDFF5F3ED2280A314E07628A3221688F1E13CE98EF2B1F10FAD1CB2349A6DED870D24FC638
717F8C|BE04FAA84D694219489EA787C5BB20DAD66B70EDDE9F0BFDFDD0342A0372493D8C1B08985E30E223990B72F79F61F862
1F877C|CC0E007927BB15ED4394285367A5B20C121C3A3D542611C90D6F66CDAE3FAC843A8AC4194852297F73BA790D73324082
EB35CF80|37DF06BBEDAC5B1D7D557AC2A670779883F7959FC834CB5D76527BBE3C5FEDA33A98D971D2A37571C8FF9DB3272846CE
B406C480|AFAAD50375932AFB200F20824F01189DD833DBD58EDC99F2D99191CD242E5FB270B9936D6BCCDA6515B3BA0C18C62CEE
CEE88040|7052D41E54741CB84C9359D0F0005312847C0206F2650E63C378B4D7A9028C7A2E8A0388573699C771338DD853CC4EF3
C584DB70|0AC547DB08727D974B1B0AA1DEBBF01D0FBADD71D55891A8686BAE81F0C7534D1BD5CE7C34B7AC615E2FA30FA43ED471
53587BC8|3A5A6A98A5728610C74BE15DF050A05977C17D1426E9CD7D47DAB5514E474348E1FABBE1BD8C0B95A82A7BBA6823F5A3
69A305B0|15AB4EDB5298FF44B8C0DAB806E7F3F548ACA00086D08BFA8F76B205584F4519D4EC3153E254862FB51C54F25D2D0884
C9375ECE|52D10549A985E2D3E6D75B2BB6E9522870A9F810A7CAFFAFBA391C6203566CE43244584B1BD8F071329F579C5330566A
C1ECFDFC|CF9E14DACB9A76EC54A6A197ADDE81BF29DAC7C10FB7239A594AFC953C9E101EF65F0EE7DCF05782DE25920D579BE99D
8D73E8A280|60C843FC06CE31A9A98C123C09141E5FD96D632369C8818DEA29149DBA14BE81FB2C58A1BF3E46BBEBDAE669A7062DF1
06F2522080|73FF28D2F7E5BE23711F224CCA327386CEABD73B9701CF13E07620BB55BAA4B1EBCC2AAD0AB24086FBA7711F20AA57CE
3EF6C36F20|38066D6F2F577221E33330DE821DFE118BA95CB241D473F1E8F6EF239E7C994D76C89848F930E1C9603DE9CDCA629E16
0127A1D340|B9FE911652FDE4D5AB128CDDBE51CECE28126E077D1EFCC0A62632F58E3C1B435675BA572B03068E0D16F2B4A1A1D056
6A6AB6C210|8337C0C7CCEAC265DFC5868B7A7C51D3E0A5BBD10C91AB9F87163F6CD8247F801AAEB2A2FDC2EC99003D6A5B238021B5
AF3175E160|8EC6670CA0F01F7C3FE7EDFFBD9418BB0DAE56B5CDDD928493BF1C707B06B45FD4D6AE67186B4BE032658C02745F6284
B66609ED86|097B6A53A02FAFD24F597B75F356DA2E5B35D106DC660FED8C8C96E11DE56671A131BAB8F2A84237312C0425AED155D8
21F134AC57|C293BF5D9DB31CEB0DCE262D21AAA71711E73CDEE3030949D508BF47CC7EE4D2DDC08211AD61B8D48DB90688C534DB02
3DC2AADFFC80|301D056017CF12B0D38F8078093B9BACAFC934A3D145AC18752F065214B42DF87DDCCAB3E1BD673F208FD5A9AB32F1A1
9202736D2240|7A1FEDA76240CAC540F828FBCD822BCAAAD8C6409E05898AFA0376FC36B6AA09169B5D89E6B372D4CBABEF4C79E07038
F219BD629820|B7C89AFDC78E0D286E20D82DB4133FBEB7C2B539A039380D925AEC704D9AD284D83FC2DA0A8779D892ADED12A71FB23A
F3511EE2C4B0|6487903B5740CAF5FF3876D7210868699D6E7DA10EE4A2763063687EE4806E279B78969F5B8233A1B1A79F7D4D0E513E
3ECAB6BF7720|960AE7DB0929C6AE9D613C8D67D0888BD0BAE985587DF20C4025E749C78D2F927A54DBC10DA246A0BF82D6D3219068A4
CD62F688F498|7576D277A0D8A361A3A3E09DD9A38485F5FF7CC36318C187B91C62EAB1271174E18A3541CAFAAA3DC827EF1A12360F46
C2CBAA33A9F8|C299176B4147C59A0B450115B077A28A3C0D02CA3DF9594A344DBC0E60179DF5F923FD75B6D75C73D65104FB873240CC
C6F50BB74E29|08154E84B32A98B5D4C1B433ACA727835D603DDDAC3F7E7D91BF06BE0717508C570A959099781D2F3DBAEF22593AF580
79F1B4CCC62A00|937BFA8DDE2EE84974F0E2F01A4CE0FD3AEF3BCC18CD4D252AF8999B5B71A577817181405DFE03AC9DF218F32F1A1FFE
