#!/usr/bin/perl

# Test that the module passes perlcritic
use strict;
BEGIN {
    $|  = 1;
    $^W = 1;
}

my @MODULES = (
    'Perl::Critic 1.098',
    'Test::Perl::Critic 1.01',
);

# Don't run tests during end-user installs
use Test::More;
plan( skip_all => 'Author tests not required for installation' )
    unless ( $ENV{RELEASE_TESTING} );

# Load the testing modules
foreach my $MODULE ( @MODULES ) {
    eval "use $MODULE";
    if ( $@ ) {
        $ENV{RELEASE_TESTING}
        ? die( "Failed to load required release-testing module $MODULE" )
        : plan( skip_all => "$MODULE not available for testing" );
    }
}

all_critic_ok();

1;
