/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedCollectionImpl
implements TimedCollection {
    private static final boolean debug = false;
    private CollectionSpecParser sp;
    private List<TimedCollection.Dataset> datasets;
    private DateRange dateRange;

    public TimedCollectionImpl(String collectionSpec, Formatter errlog) throws IOException {
        this.sp = new CollectionSpecParser(collectionSpec, errlog);
        DatasetCollectionManager manager = new DatasetCollectionManager(this.sp, errlog);
        manager.scan(null);
        List<MFile> fileList = manager.getFiles();
        this.datasets = new ArrayList<TimedCollection.Dataset>(fileList.size());
        for (MFile f : fileList) {
            this.datasets.add(new Dataset(f));
        }
        if (this.sp.getDateFormatMark() != null) {
            for (int i = 0; i < this.datasets.size() - 1; ++i) {
                Dataset d1 = (Dataset)this.datasets.get(i);
                Dataset d2 = (Dataset)this.datasets.get(i + 1);
                d1.setDateRange(new DateRange(d1.start, d2.start));
                if (i != this.datasets.size() - 2) continue;
                d2.setDateRange(new DateRange(d2.start, d1.getDateRange().getDuration()));
            }
            if (this.datasets.size() > 0) {
                Dataset first = (Dataset)this.datasets.get(0);
                Dataset last = (Dataset)this.datasets.get(this.datasets.size() - 1);
                this.dateRange = new DateRange(first.getDateRange().getStart().getDate(), last.getDateRange().getEnd().getDate());
            }
        }
    }

    private TimedCollectionImpl(TimedCollectionImpl from, DateRange want) {
        this.datasets = new ArrayList<TimedCollection.Dataset>(from.datasets.size());
        for (TimedCollection.Dataset d : from.datasets) {
            if (!want.intersects(d.getDateRange())) continue;
            this.datasets.add(d);
        }
    }

    @Override
    public TimedCollection.Dataset getPrototype() {
        return this.datasets.size() > 0 ? this.datasets.get(0) : null;
    }

    @Override
    public List<TimedCollection.Dataset> getDatasets() {
        return this.datasets;
    }

    @Override
    public TimedCollection subset(DateRange range) {
        return new TimedCollectionImpl(this, range);
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CollectionManager{%n", new Object[0]);
        for (TimedCollection.Dataset d : this.datasets) {
            f.format(" %s%n", d);
        }
        f.format("}%n", new Object[0]);
        return f.toString();
    }

    public static void doit(String spec, Formatter errlog) throws IOException {
        TimedCollectionImpl specp = new TimedCollectionImpl(spec, errlog);
        System.out.printf("spec= %s%n%s%n", spec, specp);
        String err = errlog.toString();
        if (err.length() > 0) {
            System.out.printf("%s%n", err);
        }
        System.out.printf("-----------------------------------%n", new Object[0]);
    }

    public static void main(String[] arg) throws IOException {
        TimedCollectionImpl.doit("C:/data/formats/gempak/surface/#yyyyMMdd#_sao.gem", new Formatter());
    }

    private class Dataset
    implements TimedCollection.Dataset {
        String location;
        DateRange dateRange;
        Date start;

        Dataset(MFile f) {
            this.location = f.getPath();
            if (TimedCollectionImpl.this.sp.getDateFormatMark() != null) {
                this.start = DateFromString.getDateUsingDemarkatedCount(f.getName(), TimedCollectionImpl.this.sp.getDateFormatMark(), '#');
            }
        }

        public String getLocation() {
            return this.location;
        }

        public DateRange getDateRange() {
            return this.dateRange;
        }

        public void setDateRange(DateRange dateRange) {
            this.dateRange = dateRange;
        }

        public String toString() {
            return "Dataset{location='" + this.location + '\'' + ", dateRange=" + this.dateRange + '}';
        }
    }
}

