package Google::Ads::AdWords::v201206::BiddingTransition;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %targetBiddingStrategy_of :ATTR(:get<targetBiddingStrategy>);
my %BiddingTransition__Type_of :ATTR(:get<BiddingTransition__Type>);

__PACKAGE__->_factory(
    [ qw(        targetBiddingStrategy
        BiddingTransition__Type

    ) ],
    {
        'targetBiddingStrategy' => \%targetBiddingStrategy_of,
        'BiddingTransition__Type' => \%BiddingTransition__Type_of,
    },
    {
        'targetBiddingStrategy' => 'Google::Ads::AdWords::v201206::BiddingStrategy',
        'BiddingTransition__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'targetBiddingStrategy' => 'targetBiddingStrategy',
        'BiddingTransition__Type' => 'BiddingTransition.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::BiddingTransition

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BiddingTransition from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Used to switch a campaign's bidding strategy. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * targetBiddingStrategy


=item * BiddingTransition__Type

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 BiddingTransition.Type




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

