/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    @Override
    public int getTypeAnnotation() {
        return this.tree.getTypeAnnotation(this.nodeNr);
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.tree.typeCodeArray == null) {
            return Untyped.getInstance();
        }
        return this.getConfiguration().getSchemaType(this.getTypeAnnotation());
    }

    @Override
    public SequenceIterator<? extends AtomicValue> getTypedValue() throws XPathException {
        return this.tree.getTypedValueOfElement(this).iterate();
    }

    @Override
    public Value atomize() throws XPathException {
        return this.tree.getTypedValueOfElement(this);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, buffer);
    }

    public static NamespaceBinding[] getDeclaredNamespaces(TinyTree tree, int nodeNr, NamespaceBinding[] buffer) {
        int ns = tree.beta[nodeNr];
        if (ns > 0) {
            int count = 0;
            while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                ++count;
                ++ns;
            }
            if (count == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            if (buffer != null && count <= buffer.length) {
                System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], buffer, 0, count);
                if (count < buffer.length) {
                    buffer[count] = null;
                }
                return buffer;
            }
            NamespaceBinding[] array = new NamespaceBinding[count];
            System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], array, 0, count);
            return array;
        }
        return NamespaceBinding.EMPTY_ARRAY;
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            if ((this.tree.attCode[a] & 0xFFFFF) == fingerprint) {
                return ((Object)this.tree.attValue[a]).toString();
            }
            ++a;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        NamePool pool = this.getNamePool();
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            int fp = this.tree.attCode[a] & 0xFFFFF;
            if (pool.getLocalName(fp).equals(local) && pool.getURI(fp).equals(uri)) {
                return ((Object)this.tree.attValue[a]).toString();
            }
            ++a;
        }
        return null;
    }

    @Override
    public void copy(Receiver receiver, int copyOptions, int locationId) throws XPathException {
        short level = -1;
        boolean closePending = false;
        short startLevel = this.tree.depth[this.nodeNr];
        boolean first = true;
        boolean disallowNamespaceSensitiveContent = (copyOptions & 4) != 0 && (copyOptions & 3) == 0;
        Configuration config = this.tree.getConfiguration();
        NamePool pool = config.getNamePool();
        int next = this.nodeNr;
        CopyInformee informee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        do {
            short nodeLevel = this.tree.depth[next];
            if (closePending) {
                level = (short)(level + 1);
            }
            while (level > nodeLevel) {
                receiver.endElement();
                level = (short)(level - 1);
            }
            level = nodeLevel;
            switch (this.tree.nodeKind[next]) {
                case 1: {
                    Untyped typeCode;
                    SchemaType schemaType = typeCode = CopyOptions.includes(copyOptions, 4) ? this.getConfiguration().getSchemaType(this.tree.getTypeAnnotation(next)) : Untyped.getInstance();
                    if (disallowNamespaceSensitiveContent) {
                        try {
                            this.checkNotNamespaceSensitiveElement(config, typeCode, next);
                        }
                        catch (CopyNamespaceSensitiveException e) {
                            int lang = receiver.getPipelineConfiguration().getHostLanguage();
                            e.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                            throw e;
                        }
                    }
                    if (informee != null) {
                        locationId = informee.notifyElementNode(this.tree.getNode(next));
                    }
                    int nameCode = this.tree.nameCode[next];
                    String prefix = pool.getPrefix(nameCode);
                    String uri = pool.getURI(nameCode);
                    String local = pool.getLocalName(nameCode);
                    receiver.startElement(new FingerprintedQName(prefix, uri, local, nameCode), typeCode, locationId, first ? 0 : 64);
                    closePending = true;
                    if ((copyOptions & 3) != 0 && this.tree.usesNamespaces) {
                        if (first) {
                            if ((copyOptions & 1) != 0) {
                                NamespaceBinding ns;
                                NamespaceBinding[] localNamespaces = this.getDeclaredNamespaces(null);
                                for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != null; ++i) {
                                    receiver.namespace(ns, 0);
                                }
                            } else if ((copyOptions & 2) != 0) {
                                NamespaceIterator.sendNamespaces(this, receiver);
                            }
                        } else {
                            int ns = this.tree.beta[next];
                            if (ns > 0) {
                                while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == next) {
                                    NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                                    receiver.namespace(nscode, 0);
                                    ++ns;
                                }
                            }
                        }
                    }
                    first = false;
                    int att = this.tree.alpha[next];
                    if (att >= 0) {
                        while (att < this.tree.numberOfAttributes && this.tree.attParent[att] == next) {
                            BuiltInAtomicType attType;
                            int attCode = this.tree.attCode[att];
                            SimpleType simpleType = attType = CopyOptions.includes(copyOptions, 4) ? (SimpleType)this.getConfiguration().getSchemaType(this.tree.getAttributeAnnotation(att)) : BuiltInAtomicType.UNTYPED_ATOMIC;
                            if (disallowNamespaceSensitiveContent) {
                                try {
                                    this.checkNotNamespaceSensitiveAttribute(config, attType, att);
                                }
                                catch (CopyNamespaceSensitiveException e) {
                                    int lang = receiver.getPipelineConfiguration().getHostLanguage();
                                    e.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                                    throw e;
                                }
                            }
                            receiver.attribute(new CodedName(attCode, this.getNamePool()), attType, this.tree.attValue[att], locationId, 0);
                            ++att;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    closePending = false;
                    CharSequence value = TinyTextImpl.getStringValue(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 4: {
                    closePending = false;
                    CharSequence value = WhitespaceTextImpl.getStringValueCS(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 8: {
                    closePending = false;
                    int start = this.tree.alpha[next];
                    int len = this.tree.beta[next];
                    if (len > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(start, start + len), locationId, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    closePending = false;
                    TinyNodeImpl pi = this.tree.getNode(next);
                    receiver.processingInstruction(pi.getLocalPart(), pi.getStringValue(), locationId, 0);
                    break;
                }
                case 12: {
                    closePending = false;
                }
            }
        } while (++next < this.tree.numberOfNodes && this.tree.depth[next] > startLevel);
        if (closePending) {
            level = (short)(level + 1);
        }
        while (level > startLevel) {
            receiver.endElement();
            level = (short)(level - 1);
        }
    }

    private void checkNotNamespaceSensitiveElement(Configuration config, SchemaType type, int nodeNr) throws XPathException {
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            AtomicValue val;
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            Value value = this.tree.getTypedValueOfElement(nodeNr);
            SequenceIterator iter = value.iterate();
            do {
                if ((val = (AtomicValue)iter.next()) != null) continue;
                return;
            } while (!val.getPrimitiveType().isNamespaceSensitive());
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    private void checkNotNamespaceSensitiveAttribute(Configuration config, SimpleType type, int nodeNr) throws XPathException {
        if (type.isNamespaceSensitive()) {
            AtomicValue val;
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            Value<? extends AtomicValue> value = this.tree.getTypedValueOfAttribute(null, nodeNr);
            SequenceIterator<? extends AtomicValue> iter = value.iterate();
            do {
                if ((val = iter.next()) != null) continue;
                return;
            } while (!val.getPrimitiveType().isNamespaceSensitive());
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NodeInfo parent;
        if (!(useDefault || prefix != null && prefix.length() != 0)) {
            return "";
        }
        int ns = this.tree.beta[this.nodeNr];
        if (ns > 0) {
            while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == this.nodeNr) {
                NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                if (nscode.getPrefix().equals(prefix)) {
                    String uri = nscode.getURI();
                    if (uri.length() == 0) {
                        if (prefix.length() == 0) {
                            return "";
                        }
                        return null;
                    }
                    return uri;
                }
                ++ns;
            }
        }
        if ((parent = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)parent)).getURIForPrefix(prefix, useDefault);
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

