#!/usr/bin/perl

use Test::More;
use utf8;

BEGIN { use_ok( 'Net::Gmail::IMAP::Label::Proxy' ); }
require_ok( 'Net::Gmail::IMAP::Label::Proxy' );
my $data = {
q/* 1 FETCH (X-GM-LABELS ("\\\\Important" "multi word" "\\\\Starred" "complex label") UID 33126 RFC822.SIZE 3936 INTERNALDATE "02-Aug-2012 14:02:53 +0000" FLAGS (\Answered Old \Flagged \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {405}/ =>
	q/* 1 FETCH (UID 33126 RFC822.SIZE 3936 INTERNALDATE "02-Aug-2012 14:02:53 +0000" FLAGS (\Answered Old \Flagged \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {444}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "multi word" "complex label"/,
q/* 296 FETCH (X-GM-LABELS (simple) UID 39461 RFC822.SIZE 8129 INTERNALDATE "07-Dec-2012 04:15:03 +0000" FLAGS (\Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {462}/ =>
	q/* 296 FETCH (UID 39461 RFC822.SIZE 8129 INTERNALDATE "07-Dec-2012 04:15:03 +0000" FLAGS (\Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {479}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: simple/,
q/* 299 FETCH (X-GM-LABELS (simple) UID 39466 BODY[] {10572}/ =>
	q/* 299 FETCH (UID 39466 BODY[] {10589}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: simple/,
q/* 213 FETCH (X-GM-LABELS ("\\\\Important") UID 38141 RFC822.SIZE 18747 INTERNALDATE "13-Nov-2012 15:54:38 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {421}/ =>
	q/* 213 FETCH (UID 38141 RFC822.SIZE 18747 INTERNALDATE "13-Nov-2012 15:54:38 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {421}/,
q/* 213 FETCH (X-GM-LABELS ("\\\\Important" "\\\\Starred") UID 38141 RFC822.SIZE 18747 INTERNALDATE "13-Nov-2012 15:54:38 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {421}/ =>
	q/* 213 FETCH (UID 38141 RFC822.SIZE 18747 INTERNALDATE "13-Nov-2012 15:54:38 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {421}/,
q/* 2093 FETCH (X-GM-LABELS ("\\\\Important" "multi words" "&,wglbwCwJaEAsP8JJW,+NQ- &JTslASU7-" "\\\\Starred") UID 2093 BODY[] {28208}/ =>
	q/* 2093 FETCH (UID 2093 BODY[] {28267}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "multi words" "（╯°□°）╯︵ ┻━┻"/,
q/* 3928 FETCH (X-GM-LABELS ("its &- it's") UID 3928 RFC822.SIZE 409403 INTERNALDATE "22-Jun-2012 20:10:05 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {486}/ =>
	q/* 3928 FETCH (UID 3928 RFC822.SIZE 409403 INTERNALDATE "22-Jun-2012 20:10:05 +0000" FLAGS (Old \Seen) BODY[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] {509}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "its & it's"/,
q/* 537 FETCH (X-GM-LABELS ("parens ()") UID 1471 BODY[] {873}/ =>
	q/* 537 FETCH (UID 1471 BODY[] {895}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "parens ()"/,
q/* 14496 FETCH (X-GM-LABELS ("\\\\Sent" "(" "()") UID 25337 BODY[] {650}/ =>
	q/* 14496 FETCH (UID 25337 BODY[] {669}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "(" "()"/,
q/* 537 FETCH (X-GM-LABELS ("zzzz\"" "\\\\Sent" "zzz)" "zz(") UID 1471 BODY[] {873}/ =>
	q/* 537 FETCH (UID 1471 BODY[] {905}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "zzzz\"" "zzz)" "zz("/,
q/* 138 FETCH (X-GM-LABELS ("\\\\Important" "\\\\Sent" "\\\\") UID 36833 BODY[] {841}/ =>
	q/* 138 FETCH (UID 36833 BODY[] {856}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: "\\\\"/,
q/* 286 FETCH (X-GM-LABELS (Test ")") UID 39560 BODY[] {44795}/ =>
	q/* 286 FETCH (UID 39560 BODY[] {44814}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: Test ")"/,
q/* 283 FETCH (X-GM-LABELS (&- Test) UID 39557 BODY[] {10730}/ =>
	q/* 283 FETCH (UID 39557 BODY[] {10747}/.
	Net::Gmail::IMAP::Label::Proxy::LINESEP.
	q/X-Label: & Test/,
q/* 286 FETCH (X-GM-LABELS () UID 39560 BODY[] {44795}/ =>
	# empty labels should not generate X-Label
	q/* 286 FETCH (UID 39560 BODY[] {44795}/,
'* 3928 NOT A RESPONSE' => '* 3928 NOT A RESPONSE', # Not a FETCH
q/* 286 FETCH (X-GM-LABELS (Broken ")""") UID 39560 BODY[] {44795}/ =>
	# this will not parse because two strings can not be adjacent
	q/* 286 FETCH (X-GM-LABELS (Broken ")""") UID 39560 BODY[] {44795}/,
};

while (($key, $value) = each %$data) {
	subtest 'put_label transform' => sub {
		is(Net::Gmail::IMAP::Label::Proxy::put_label($key), $value, 'correct response');
	};
}


done_testing;
