package Dist::Zilla::App::Command::mkrpmspec;
# ABSTRACT: generate RPM spec file from your template

use strict;
use warnings;
use Carp;

use Dist::Zilla::App -command;

our $VERSION = '0.006'; # VERSION

sub abstract { 'generate RPM spec file from your build template' }

sub execute {
    my($self,$opt,$args) = @_;
    my($filename) = @{$args};
    $filename ||= 'dzil.spec';

    require Path::Class;

    $_->before_build     for @{ $self->zilla->plugins_with(-BeforeBuild) };
    $_->gather_files     for @{ $self->zilla->plugins_with(-FileGatherer) };
    $_->prune_files      for @{ $self->zilla->plugins_with(-FilePruner) };
    $_->register_prereqs for @{ $self->zilla->plugins_with(-PrereqSource) };

    my $outfile = Path::Class::File->new($filename);
    my $out = $outfile->openw;
    print $out $self->zilla->plugin_named('RPM')->mk_spec(
        sprintf('%s-%s.tar.gz',$self->zilla->name,$self->zilla->version)
    );

    $self->log("spec file written to $outfile");
}

1;



=pod

=head1 NAME

Dist::Zilla::App::Command::mkrpmspec - generate RPM spec file from your template

=head1 VERSION

version 0.006

=head1 SYNOPSIS

  dzil mkrpmspec [filename]

=head1 DESCRIPTION

This command writes a parsed version of the spec file that would be generated by
L<Dist::Zilla::Plugin::RPM|Dist::Zilla::Plugin::RPM> during release, without
having to do a full release. This is useful for testing or tweaking your RPM
build without having to run dzil each time.

=head1 EXAMPLE

  $ dzil mkrpmspec
  $ dzil mkrpmspec /path/to/foo.spec

=head1 OPTIONS

=head2 filename (default: "./dzil.spec")

The filename to write the specfile to.

=head1 AUTHOR

Stephen Clouse <stephenclouse@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Stephen Clouse.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__
