package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-06-12'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240612.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'BDFOY' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JV' => '',
    'AJNN' => '',
    'WYANT' => '',
    'TEAM' => '',
    'BPS' => '',
    'RKAPL' => '',
    'JRM' => '',
    'SREZIC' => '',
    'DAMI' => '',
    'RJBS' => '',
    'INGY' => '',
    'KUERBIS' => '',
    'DAVECROSS' => '',
    'MATHIAS' => '',
    'ETJ' => '',
    'LNATION' => '',
    'NHORNE' => '',
    'DDICK' => '',
    'LEONT' => '',
    'SISYPHUS' => '',
    'BRIANDFOY' => '',
    'EXODIST' => '',
    'GBROWN' => '',
    'HANJE' => '',
    'JAVONET' => '',
    'JONASBN' => '',
    'MRUEDA' => '',
    'PLICEASE' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'ABRAXXA' => '',
    'KHEDIN' => '',
    'TANIGUCHI' => '',
    'WATERKIP' => '',
    'CORION' => '',
    'DCANTRELL' => '',
    'GENE' => '',
    'TRIZEN' => '',
    'GRYPHON' => '',
    'JOESUF' => '',
    'NERDVANA' => '',
    'ARFREITAS' => '',
    'CHOROBA' => '',
    'GSG' => '',
    'JJATRIA' => '',
    'KRYDE' => '',
    'NLNETLABS' => '',
    'REEDFISH' => '',
    'TONYC' => '',
    'TURNERJW' => '',
    'BPSCHUCK' => '',
    'CAPOEIRAB' => '',
    'DRCLAW' => '',
    'FASTLY' => '',
    'GDT' => '',
    'HMBRAND' => '',
    'ISHIGAKI' => '',
    'KARASIK' => '',
    'LITCHIE' => '',
    'PAYJP' => '',
    'PREACTION' => '',
    'RURBAN' => '',
    'SPWHITTON' => '',
    'TEODESIAN' => '',
    'UXYZAB' => '',
    'DART' => '',
    'DVEEDEN' => '',
    'EHUELS' => '',
    'HAARG' => '',
    'KALDOR' => '',
    'LHRST' => '',
    'MARIOROY' => '',
    'MARKOV' => '',
    'NAUTOFON' => '',
    'SRI' => '',
    'TVIGNAUD' => '',
    'AKXLIX' => '',
    'BAYASHI' => '',
    'BIGFOOT' => '',
    'BINARY' => '',
    'BLHOTSKY' => '',
    'BWEST' => '',
    'CAVAC' => '',
    'COLINK' => '',
    'CRUX' => '',
    'DAGOLDEN' => '',
    'DAM' => '',
    'DERIV' => '',
    'EDF' => '',
    'EGILES' => '',
    'GAHAYES' => '',
    'GIBUS' => '',
    'GLBRUNE' => '',
    'GRAY' => '',
    'JETTERO' => '',
    'LANODAN' => '',
    'LIYAO' => '',
    'MAMAWE' => '',
    'MARDEM' => '',
    'MBALLARIN' => '',
    'MBESSON' => '',
    'MICKEY' => '',
    'MIYAGAWA' => '',
    'MJONDET' => '',
    'MOOCOW' => '',
    'MPOURASG' => '',
    'MVSJES' => '',
    'OLOF' => '',
    'OVID' => '',
    'PETERCJ' => '',
    'PJACKLAM' => '',
    'QGARNIER' => '',
    'RATCLIFFE' => '',
    'SCESANO' => '',
    'SGRAY' => '',
    'SHANCOCK' => '',
    'SLAFFAN' => '',
    'SSIMMS' => '',
    'STEFFENW' => '',
    'SVW' => '',
    'TCHATZI' => '',
    'TINITA' => '',
    'VANHOESEL' => '',
    'VDANJEAN' => '',
    'WESLEY' => '',
    'WORTHMINE' => '',
    'YOSHIMASA' => '',
    'ZARQUON' => '',
    'BALDUR' => '',
    'BOD' => '',
    'BRTASTIC' => '',
    'BURAK' => '',
    'CADE' => '',
    'CHEVALIER' => '',
    'CHRISARG' => '',
    'DBOOK' => '',
    'DDRP' => '',
    'EXTISM' => '',
    'FSEITZ' => '',
    'HIREPLAN' => '',
    'KARMAN' => '',
    'KIM' => '',
    'MBARBON' => '',
    'MELMOTHX' => '',
    'MYDMNSN' => '',
    'PATJOL' => '',
    'PEVANS' => '',
    'PJCJ' => '',
    'PROCH' => '',
    'RADIUSCZ' => '',
    'RKELSCH' => '',
    'RWF' => '',
    'SBECK' => '',
    'SHLOMIF' => '',
    'SHOGO' => '',
    'TIMLEGGE' => '',
    'VOEGELAS' => '',
    'VVELOX' => '',
    'WDAEMS' => '',
    'YTURTLE' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240612.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-06-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-06-12, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 220 | 2006-03    | ongoing     |
  | ETHER     | 148 | 2012-03    | ongoing     |
  | LEEJO     | 123 | 2014-04    | ongoing     |
  | PERLANCAR | 119 | 2014-08    | ongoing     |
  | UTASHIRO  |  72 | 2018-06    | might-break |
  | OALDERS   |  59 | 2019-08    | ongoing     |
  | KIMOTO    |  31 | 2021-12    | ongoing     |
  | OLIVER    |  28 | 2022-02    | might-break |
  | SKIM      |  27 | 2022-04    | ongoing     |
  | DERF      |  25 | 2022-06    | ongoing     |
  | JDEGUEST  |  24 | 2022-06    | might-break |
  | BDFOY     |  18 | 2023-01    | ongoing     |
  | ASPOSE    |  17 | 2023-02    | ongoing     |
  | DJERIUS   |  15 | 2023-03    | might-break |
  | JV        |  14 | 2023-05    | ongoing     |
  | AJNN      |  12 | 2023-06    | might-break |
  | WYANT     |  11 | 2023-08    | ongoing     |
  | TEAM      |  10 | 2023-08    | might-break |
  | BPS       |   9 | 2023-09    | might-break |
  | RKAPL     |   9 | 2023-09    | might-break |
  | JRM       |   9 | 2023-10    | ongoing     |
  | SREZIC    |   8 | 2023-10    | might-break |
  | DAMI      |   8 | 2023-11    | ongoing     |
  | RJBS      |   8 | 2023-11    | ongoing     |
  | INGY      |   7 | 2023-12    | ongoing     |
  | KUERBIS   |   7 | 2023-12    | ongoing     |
  | DAVECROSS |   6 | 2023-12    | might-break |
  | MATHIAS   |   6 | 2023-12    | might-break |
  | ETJ       |   6 | 2024-01    | ongoing     |
  | LNATION   |   6 | 2024-01    | ongoing     |
  | NHORNE    |   6 | 2024-01    | ongoing     |
  | DDICK     |   5 | 2024-01    | might-break |
  | LEONT     |   5 | 2024-01    | might-break |
  | SISYPHUS  |   5 | 2024-01    | might-break |
  | BRIANDFOY |   5 | 2024-02    | ongoing     |
  | EXODIST   |   5 | 2024-02    | ongoing     |
  | GBROWN    |   5 | 2024-02    | ongoing     |
  | HANJE     |   5 | 2024-02    | ongoing     |
  | JAVONET   |   5 | 2024-02    | ongoing     |
  | JONASBN   |   5 | 2024-02    | ongoing     |
  | MRUEDA    |   5 | 2024-02    | ongoing     |
  | PLICEASE  |   5 | 2024-02    | ongoing     |
  | TIMKA     |   5 | 2024-02    | ongoing     |
  | TYRRMINAL |   5 | 2024-02    | ongoing     |
  | ABRAXXA   |   4 | 2024-02    | might-break |
  | KHEDIN    |   4 | 2024-02    | might-break |
  | TANIGUCHI |   4 | 2024-02    | might-break |
  | WATERKIP  |   4 | 2024-02    | might-break |
  | CORION    |   4 | 2024-03    | ongoing     |
  | DCANTRELL |   4 | 2024-03    | ongoing     |
  | GENE      |   4 | 2024-03    | ongoing     |
  | TRIZEN    |   4 | 2024-03    | ongoing     |
  | GRYPHON   |   3 | 2024-03    | might-break |
  | JOESUF    |   3 | 2024-03    | might-break |
  | NERDVANA  |   3 | 2024-03    | might-break |
  | ARFREITAS |   3 | 2024-04    | ongoing     |
  | CHOROBA   |   3 | 2024-04    | ongoing     |
  | GSG       |   3 | 2024-04    | ongoing     |
  | JJATRIA   |   3 | 2024-04    | ongoing     |
  | KRYDE     |   3 | 2024-04    | ongoing     |
  | NLNETLABS |   3 | 2024-04    | ongoing     |
  | REEDFISH  |   3 | 2024-04    | ongoing     |
  | TONYC     |   3 | 2024-04    | ongoing     |
  | TURNERJW  |   3 | 2024-04    | ongoing     |
  | BPSCHUCK  |   2 | 2024-04    | might-break |
  | CAPOEIRAB |   2 | 2024-04    | might-break |
  | DRCLAW    |   2 | 2024-04    | might-break |
  | FASTLY    |   2 | 2024-04    | might-break |
  | GDT       |   2 | 2024-04    | might-break |
  | HMBRAND   |   2 | 2024-04    | might-break |
  | ISHIGAKI  |   2 | 2024-04    | might-break |
  | KARASIK   |   2 | 2024-04    | might-break |
  | LITCHIE   |   2 | 2024-04    | might-break |
  | PAYJP     |   2 | 2024-04    | might-break |
  | PREACTION |   2 | 2024-04    | might-break |
  | RURBAN    |   2 | 2024-04    | might-break |
  | SPWHITTON |   2 | 2024-04    | might-break |
  | TEODESIAN |   2 | 2024-04    | might-break |
  | UXYZAB    |   2 | 2024-04    | might-break |
  | DART      |   2 | 2024-05    | ongoing     |
  | DVEEDEN   |   2 | 2024-05    | ongoing     |
  | EHUELS    |   2 | 2024-05    | ongoing     |
  | HAARG     |   2 | 2024-05    | ongoing     |
  | KALDOR    |   2 | 2024-05    | ongoing     |
  | LHRST     |   2 | 2024-05    | ongoing     |
  | MARIOROY  |   2 | 2024-05    | ongoing     |
  | MARKOV    |   2 | 2024-05    | ongoing     |
  | NAUTOFON  |   2 | 2024-05    | ongoing     |
  | SRI       |   2 | 2024-05    | ongoing     |
  | TVIGNAUD  |   2 | 2024-05    | ongoing     |
  | AKXLIX    |   1 | 2024-05    | might-break |
  | BAYASHI   |   1 | 2024-05    | might-break |
  | BIGFOOT   |   1 | 2024-05    | might-break |
  | BINARY    |   1 | 2024-05    | might-break |
  | BLHOTSKY  |   1 | 2024-05    | might-break |
  | BWEST     |   1 | 2024-05    | might-break |
  | CAVAC     |   1 | 2024-05    | might-break |
  | COLINK    |   1 | 2024-05    | might-break |
  | CRUX      |   1 | 2024-05    | might-break |
  | DAGOLDEN  |   1 | 2024-05    | might-break |
  | DAM       |   1 | 2024-05    | might-break |
  | DERIV     |   1 | 2024-05    | might-break |
  | EDF       |   1 | 2024-05    | might-break |
  | EGILES    |   1 | 2024-05    | might-break |
  | GAHAYES   |   1 | 2024-05    | might-break |
  | GIBUS     |   1 | 2024-05    | might-break |
  | GLBRUNE   |   1 | 2024-05    | might-break |
  | GRAY      |   1 | 2024-05    | might-break |
  | JETTERO   |   1 | 2024-05    | might-break |
  | LANODAN   |   1 | 2024-05    | might-break |
  | LIYAO     |   1 | 2024-05    | might-break |
  | MAMAWE    |   1 | 2024-05    | might-break |
  | MARDEM    |   1 | 2024-05    | might-break |
  | MBALLARIN |   1 | 2024-05    | might-break |
  | MBESSON   |   1 | 2024-05    | might-break |
  | MICKEY    |   1 | 2024-05    | might-break |
  | MIYAGAWA  |   1 | 2024-05    | might-break |
  | MJONDET   |   1 | 2024-05    | might-break |
  | MOOCOW    |   1 | 2024-05    | might-break |
  | MPOURASG  |   1 | 2024-05    | might-break |
  | MVSJES    |   1 | 2024-05    | might-break |
  | OLOF      |   1 | 2024-05    | might-break |
  | OVID      |   1 | 2024-05    | might-break |
  | PETERCJ   |   1 | 2024-05    | might-break |
  | PJACKLAM  |   1 | 2024-05    | might-break |
  | QGARNIER  |   1 | 2024-05    | might-break |
  | RATCLIFFE |   1 | 2024-05    | might-break |
  | SCESANO   |   1 | 2024-05    | might-break |
  | SGRAY     |   1 | 2024-05    | might-break |
  | SHANCOCK  |   1 | 2024-05    | might-break |
  | SLAFFAN   |   1 | 2024-05    | might-break |
  | SSIMMS    |   1 | 2024-05    | might-break |
  | STEFFENW  |   1 | 2024-05    | might-break |
  | SVW       |   1 | 2024-05    | might-break |
  | TCHATZI   |   1 | 2024-05    | might-break |
  | TINITA    |   1 | 2024-05    | might-break |
  | VANHOESEL |   1 | 2024-05    | might-break |
  | VDANJEAN  |   1 | 2024-05    | might-break |
  | WESLEY    |   1 | 2024-05    | might-break |
  | WORTHMINE |   1 | 2024-05    | might-break |
  | YOSHIMASA |   1 | 2024-05    | might-break |
  | ZARQUON   |   1 | 2024-05    | might-break |
  | BALDUR    |   1 | 2024-06    | ongoing     |
  | BOD       |   1 | 2024-06    | ongoing     |
  | BRTASTIC  |   1 | 2024-06    | ongoing     |
  | BURAK     |   1 | 2024-06    | ongoing     |
  | CADE      |   1 | 2024-06    | ongoing     |
  | CHEVALIER |   1 | 2024-06    | ongoing     |
  | CHRISARG  |   1 | 2024-06    | ongoing     |
  | DBOOK     |   1 | 2024-06    | ongoing     |
  | DDRP      |   1 | 2024-06    | ongoing     |
  | EXTISM    |   1 | 2024-06    | ongoing     |
  | FSEITZ    |   1 | 2024-06    | ongoing     |
  | HIREPLAN  |   1 | 2024-06    | ongoing     |
  | KARMAN    |   1 | 2024-06    | ongoing     |
  | KIM       |   1 | 2024-06    | ongoing     |
  | MBARBON   |   1 | 2024-06    | ongoing     |
  | MELMOTHX  |   1 | 2024-06    | ongoing     |
  | MYDMNSN   |   1 | 2024-06    | ongoing     |
  | PATJOL    |   1 | 2024-06    | ongoing     |
  | PEVANS    |   1 | 2024-06    | ongoing     |
  | PJCJ      |   1 | 2024-06    | ongoing     |
  | PROCH     |   1 | 2024-06    | ongoing     |
  | RADIUSCZ  |   1 | 2024-06    | ongoing     |
  | RKELSCH   |   1 | 2024-06    | ongoing     |
  | RWF       |   1 | 2024-06    | ongoing     |
  | SBECK     |   1 | 2024-06    | ongoing     |
  | SHLOMIF   |   1 | 2024-06    | ongoing     |
  | SHOGO     |   1 | 2024-06    | ongoing     |
  | TIMLEGGE  |   1 | 2024-06    | ongoing     |
  | VOEGELAS  |   1 | 2024-06    | ongoing     |
  | VVELOX    |   1 | 2024-06    | ongoing     |
  | WDAEMS    |   1 | 2024-06    | ongoing     |
  | YTURTLE   |   1 | 2024-06    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
