# This file is part of Pootle-Client.

package t::Mock::Resource::Projects;

use Modern::Perl '2015';
use utf8;
binmode STDOUT, ':encoding(UTF-8)';
binmode STDERR, ':encoding(UTF-8)';
use feature 'signatures'; no warnings "experimental::signatures";
use Carp::Always;
use Try::Tiny;
use Scalar::Util qw(blessed);


use base('t::Mock::Resource');

use Pootle::Resource::Project;

my $objects;
my $lookup;
my $responseDump;

sub one($papi, $endpoint) {
  ($objects, $lookup) = __PACKAGE__->init($responseDump, 'Pootle::Resource::Project') unless ($objects && $lookup);
  return $lookup->{$endpoint};
}

sub all($papi) {
  ($objects, $lookup) = __PACKAGE__->init($responseDump, 'Pootle::Resource::Project') unless ($objects && $lookup);
  return $objects if $objects;
}

$responseDump = [
  {
    'checkstyle' => 'standard',
    'code' => '16.05',
    'description' => '',
    'fullname' => 'Koha 16.05',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/23/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/989/',
      '/api/v1/translation-projects/990/',
      '/api/v1/translation-projects/991/',
      '/api/v1/translation-projects/992/',
      '/api/v1/translation-projects/993/',
      '/api/v1/translation-projects/994/',
      '/api/v1/translation-projects/995/',
      '/api/v1/translation-projects/996/',
      '/api/v1/translation-projects/997/',
      '/api/v1/translation-projects/998/',
      '/api/v1/translation-projects/999/',
      '/api/v1/translation-projects/1000/',
      '/api/v1/translation-projects/1001/',
      '/api/v1/translation-projects/1002/',
      '/api/v1/translation-projects/1003/',
      '/api/v1/translation-projects/1004/',
      '/api/v1/translation-projects/1005/',
      '/api/v1/translation-projects/1006/',
      '/api/v1/translation-projects/1007/',
      '/api/v1/translation-projects/1008/',
      '/api/v1/translation-projects/1009/',
      '/api/v1/translation-projects/1010/',
      '/api/v1/translation-projects/1011/',
      '/api/v1/translation-projects/1012/',
      '/api/v1/translation-projects/1013/',
      '/api/v1/translation-projects/1014/',
      '/api/v1/translation-projects/1015/',
      '/api/v1/translation-projects/1016/',
      '/api/v1/translation-projects/1017/',
      '/api/v1/translation-projects/1018/',
      '/api/v1/translation-projects/1019/',
      '/api/v1/translation-projects/1020/',
      '/api/v1/translation-projects/1021/',
      '/api/v1/translation-projects/1022/',
      '/api/v1/translation-projects/1023/',
      '/api/v1/translation-projects/1024/',
      '/api/v1/translation-projects/1025/',
      '/api/v1/translation-projects/1026/',
      '/api/v1/translation-projects/1027/',
      '/api/v1/translation-projects/1028/',
      '/api/v1/translation-projects/1029/',
      '/api/v1/translation-projects/1030/',
      '/api/v1/translation-projects/1031/',
      '/api/v1/translation-projects/1032/',
      '/api/v1/translation-projects/1033/',
      '/api/v1/translation-projects/1034/',
      '/api/v1/translation-projects/1035/',
      '/api/v1/translation-projects/1036/',
      '/api/v1/translation-projects/1037/',
      '/api/v1/translation-projects/1038/',
      '/api/v1/translation-projects/1039/',
      '/api/v1/translation-projects/1040/',
      '/api/v1/translation-projects/1041/',
      '/api/v1/translation-projects/1042/',
      '/api/v1/translation-projects/1043/',
      '/api/v1/translation-projects/1044/',
      '/api/v1/translation-projects/1045/',
      '/api/v1/translation-projects/1046/',
      '/api/v1/translation-projects/1047/',
      '/api/v1/translation-projects/1048/',
      '/api/v1/translation-projects/1049/',
      '/api/v1/translation-projects/1050/',
      '/api/v1/translation-projects/1051/',
      '/api/v1/translation-projects/1052/',
      '/api/v1/translation-projects/1053/',
      '/api/v1/translation-projects/1054/',
      '/api/v1/translation-projects/1055/',
      '/api/v1/translation-projects/1056/',
      '/api/v1/translation-projects/1057/',
      '/api/v1/translation-projects/1058/',
      '/api/v1/translation-projects/1059/',
      '/api/v1/translation-projects/1060/',
      '/api/v1/translation-projects/1061/',
      '/api/v1/translation-projects/1062/',
      '/api/v1/translation-projects/1063/',
      '/api/v1/translation-projects/1064/',
      '/api/v1/translation-projects/1065/',
      '/api/v1/translation-projects/1066/',
      '/api/v1/translation-projects/1067/',
      '/api/v1/translation-projects/1068/',
      '/api/v1/translation-projects/1071/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '16.11',
    'description' => '',
    'fullname' => 'Koha 16.11',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/25/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/1083/',
      '/api/v1/translation-projects/1084/',
      '/api/v1/translation-projects/1085/',
      '/api/v1/translation-projects/1086/',
      '/api/v1/translation-projects/1087/',
      '/api/v1/translation-projects/1088/',
      '/api/v1/translation-projects/1089/',
      '/api/v1/translation-projects/1090/',
      '/api/v1/translation-projects/1091/',
      '/api/v1/translation-projects/1092/',
      '/api/v1/translation-projects/1093/',
      '/api/v1/translation-projects/1094/',
      '/api/v1/translation-projects/1095/',
      '/api/v1/translation-projects/1096/',
      '/api/v1/translation-projects/1097/',
      '/api/v1/translation-projects/1098/',
      '/api/v1/translation-projects/1099/',
      '/api/v1/translation-projects/1100/',
      '/api/v1/translation-projects/1101/',
      '/api/v1/translation-projects/1102/',
      '/api/v1/translation-projects/1103/',
      '/api/v1/translation-projects/1104/',
      '/api/v1/translation-projects/1105/',
      '/api/v1/translation-projects/1106/',
      '/api/v1/translation-projects/1107/',
      '/api/v1/translation-projects/1108/',
      '/api/v1/translation-projects/1109/',
      '/api/v1/translation-projects/1110/',
      '/api/v1/translation-projects/1111/',
      '/api/v1/translation-projects/1112/',
      '/api/v1/translation-projects/1113/',
      '/api/v1/translation-projects/1114/',
      '/api/v1/translation-projects/1115/',
      '/api/v1/translation-projects/1116/',
      '/api/v1/translation-projects/1117/',
      '/api/v1/translation-projects/1118/',
      '/api/v1/translation-projects/1119/',
      '/api/v1/translation-projects/1120/',
      '/api/v1/translation-projects/1121/',
      '/api/v1/translation-projects/1122/',
      '/api/v1/translation-projects/1123/',
      '/api/v1/translation-projects/1124/',
      '/api/v1/translation-projects/1125/',
      '/api/v1/translation-projects/1126/',
      '/api/v1/translation-projects/1127/',
      '/api/v1/translation-projects/1128/',
      '/api/v1/translation-projects/1129/',
      '/api/v1/translation-projects/1130/',
      '/api/v1/translation-projects/1131/',
      '/api/v1/translation-projects/1132/',
      '/api/v1/translation-projects/1133/',
      '/api/v1/translation-projects/1134/',
      '/api/v1/translation-projects/1135/',
      '/api/v1/translation-projects/1136/',
      '/api/v1/translation-projects/1137/',
      '/api/v1/translation-projects/1138/',
      '/api/v1/translation-projects/1139/',
      '/api/v1/translation-projects/1140/',
      '/api/v1/translation-projects/1141/',
      '/api/v1/translation-projects/1142/',
      '/api/v1/translation-projects/1143/',
      '/api/v1/translation-projects/1144/',
      '/api/v1/translation-projects/1145/',
      '/api/v1/translation-projects/1146/',
      '/api/v1/translation-projects/1147/',
      '/api/v1/translation-projects/1148/',
      '/api/v1/translation-projects/1149/',
      '/api/v1/translation-projects/1150/',
      '/api/v1/translation-projects/1151/',
      '/api/v1/translation-projects/1152/',
      '/api/v1/translation-projects/1153/',
      '/api/v1/translation-projects/1154/',
      '/api/v1/translation-projects/1155/',
      '/api/v1/translation-projects/1156/',
      '/api/v1/translation-projects/1157/',
      '/api/v1/translation-projects/1158/',
      '/api/v1/translation-projects/1159/',
      '/api/v1/translation-projects/1160/',
      '/api/v1/translation-projects/1161/',
      '/api/v1/translation-projects/1162/',
      '/api/v1/translation-projects/1163/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '17.05',
    'description' => '',
    'fullname' => 'Koha 17.05',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/26/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/1165/',
      '/api/v1/translation-projects/1166/',
      '/api/v1/translation-projects/1167/',
      '/api/v1/translation-projects/1168/',
      '/api/v1/translation-projects/1169/',
      '/api/v1/translation-projects/1170/',
      '/api/v1/translation-projects/1171/',
      '/api/v1/translation-projects/1172/',
      '/api/v1/translation-projects/1173/',
      '/api/v1/translation-projects/1174/',
      '/api/v1/translation-projects/1175/',
      '/api/v1/translation-projects/1176/',
      '/api/v1/translation-projects/1177/',
      '/api/v1/translation-projects/1178/',
      '/api/v1/translation-projects/1179/',
      '/api/v1/translation-projects/1180/',
      '/api/v1/translation-projects/1181/',
      '/api/v1/translation-projects/1182/',
      '/api/v1/translation-projects/1183/',
      '/api/v1/translation-projects/1184/',
      '/api/v1/translation-projects/1185/',
      '/api/v1/translation-projects/1186/',
      '/api/v1/translation-projects/1187/',
      '/api/v1/translation-projects/1188/',
      '/api/v1/translation-projects/1189/',
      '/api/v1/translation-projects/1190/',
      '/api/v1/translation-projects/1191/',
      '/api/v1/translation-projects/1192/',
      '/api/v1/translation-projects/1193/',
      '/api/v1/translation-projects/1194/',
      '/api/v1/translation-projects/1195/',
      '/api/v1/translation-projects/1196/',
      '/api/v1/translation-projects/1197/',
      '/api/v1/translation-projects/1198/',
      '/api/v1/translation-projects/1199/',
      '/api/v1/translation-projects/1200/',
      '/api/v1/translation-projects/1201/',
      '/api/v1/translation-projects/1202/',
      '/api/v1/translation-projects/1203/',
      '/api/v1/translation-projects/1204/',
      '/api/v1/translation-projects/1205/',
      '/api/v1/translation-projects/1206/',
      '/api/v1/translation-projects/1207/',
      '/api/v1/translation-projects/1208/',
      '/api/v1/translation-projects/1209/',
      '/api/v1/translation-projects/1210/',
      '/api/v1/translation-projects/1211/',
      '/api/v1/translation-projects/1212/',
      '/api/v1/translation-projects/1213/',
      '/api/v1/translation-projects/1214/',
      '/api/v1/translation-projects/1215/',
      '/api/v1/translation-projects/1216/',
      '/api/v1/translation-projects/1217/',
      '/api/v1/translation-projects/1218/',
      '/api/v1/translation-projects/1219/',
      '/api/v1/translation-projects/1220/',
      '/api/v1/translation-projects/1221/',
      '/api/v1/translation-projects/1222/',
      '/api/v1/translation-projects/1223/',
      '/api/v1/translation-projects/1224/',
      '/api/v1/translation-projects/1225/',
      '/api/v1/translation-projects/1226/',
      '/api/v1/translation-projects/1227/',
      '/api/v1/translation-projects/1228/',
      '/api/v1/translation-projects/1229/',
      '/api/v1/translation-projects/1230/',
      '/api/v1/translation-projects/1231/',
      '/api/v1/translation-projects/1232/',
      '/api/v1/translation-projects/1233/',
      '/api/v1/translation-projects/1234/',
      '/api/v1/translation-projects/1235/',
      '/api/v1/translation-projects/1236/',
      '/api/v1/translation-projects/1237/',
      '/api/v1/translation-projects/1238/',
      '/api/v1/translation-projects/1239/',
      '/api/v1/translation-projects/1240/',
      '/api/v1/translation-projects/1241/',
      '/api/v1/translation-projects/1242/',
      '/api/v1/translation-projects/1243/',
      '/api/v1/translation-projects/1244/',
      '/api/v1/translation-projects/1245/',
      '/api/v1/translation-projects/1246/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '3.20',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.20',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/19/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/815/',
      '/api/v1/translation-projects/816/',
      '/api/v1/translation-projects/817/',
      '/api/v1/translation-projects/818/',
      '/api/v1/translation-projects/819/',
      '/api/v1/translation-projects/820/',
      '/api/v1/translation-projects/821/',
      '/api/v1/translation-projects/822/',
      '/api/v1/translation-projects/823/',
      '/api/v1/translation-projects/824/',
      '/api/v1/translation-projects/825/',
      '/api/v1/translation-projects/826/',
      '/api/v1/translation-projects/827/',
      '/api/v1/translation-projects/828/',
      '/api/v1/translation-projects/829/',
      '/api/v1/translation-projects/830/',
      '/api/v1/translation-projects/831/',
      '/api/v1/translation-projects/832/',
      '/api/v1/translation-projects/833/',
      '/api/v1/translation-projects/834/',
      '/api/v1/translation-projects/835/',
      '/api/v1/translation-projects/836/',
      '/api/v1/translation-projects/837/',
      '/api/v1/translation-projects/838/',
      '/api/v1/translation-projects/839/',
      '/api/v1/translation-projects/840/',
      '/api/v1/translation-projects/841/',
      '/api/v1/translation-projects/842/',
      '/api/v1/translation-projects/843/',
      '/api/v1/translation-projects/844/',
      '/api/v1/translation-projects/845/',
      '/api/v1/translation-projects/846/',
      '/api/v1/translation-projects/847/',
      '/api/v1/translation-projects/848/',
      '/api/v1/translation-projects/849/',
      '/api/v1/translation-projects/850/',
      '/api/v1/translation-projects/851/',
      '/api/v1/translation-projects/852/',
      '/api/v1/translation-projects/853/',
      '/api/v1/translation-projects/854/',
      '/api/v1/translation-projects/855/',
      '/api/v1/translation-projects/856/',
      '/api/v1/translation-projects/857/',
      '/api/v1/translation-projects/858/',
      '/api/v1/translation-projects/859/',
      '/api/v1/translation-projects/860/',
      '/api/v1/translation-projects/861/',
      '/api/v1/translation-projects/862/',
      '/api/v1/translation-projects/863/',
      '/api/v1/translation-projects/864/',
      '/api/v1/translation-projects/865/',
      '/api/v1/translation-projects/866/',
      '/api/v1/translation-projects/867/',
      '/api/v1/translation-projects/868/',
      '/api/v1/translation-projects/869/',
      '/api/v1/translation-projects/870/',
      '/api/v1/translation-projects/871/',
      '/api/v1/translation-projects/872/',
      '/api/v1/translation-projects/873/',
      '/api/v1/translation-projects/874/',
      '/api/v1/translation-projects/875/',
      '/api/v1/translation-projects/876/',
      '/api/v1/translation-projects/877/',
      '/api/v1/translation-projects/878/',
      '/api/v1/translation-projects/879/',
      '/api/v1/translation-projects/880/',
      '/api/v1/translation-projects/881/',
      '/api/v1/translation-projects/882/',
      '/api/v1/translation-projects/883/',
      '/api/v1/translation-projects/884/',
      '/api/v1/translation-projects/885/',
      '/api/v1/translation-projects/886/',
      '/api/v1/translation-projects/887/',
      '/api/v1/translation-projects/890/',
      '/api/v1/translation-projects/892/',
      '/api/v1/translation-projects/1070/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '3.22',
    'description' => '',
    'fullname' => 'Koha 3.22',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/20/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/893/',
      '/api/v1/translation-projects/894/',
      '/api/v1/translation-projects/895/',
      '/api/v1/translation-projects/896/',
      '/api/v1/translation-projects/897/',
      '/api/v1/translation-projects/898/',
      '/api/v1/translation-projects/899/',
      '/api/v1/translation-projects/900/',
      '/api/v1/translation-projects/901/',
      '/api/v1/translation-projects/902/',
      '/api/v1/translation-projects/903/',
      '/api/v1/translation-projects/904/',
      '/api/v1/translation-projects/905/',
      '/api/v1/translation-projects/906/',
      '/api/v1/translation-projects/907/',
      '/api/v1/translation-projects/908/',
      '/api/v1/translation-projects/909/',
      '/api/v1/translation-projects/910/',
      '/api/v1/translation-projects/911/',
      '/api/v1/translation-projects/912/',
      '/api/v1/translation-projects/913/',
      '/api/v1/translation-projects/914/',
      '/api/v1/translation-projects/915/',
      '/api/v1/translation-projects/916/',
      '/api/v1/translation-projects/917/',
      '/api/v1/translation-projects/918/',
      '/api/v1/translation-projects/919/',
      '/api/v1/translation-projects/920/',
      '/api/v1/translation-projects/921/',
      '/api/v1/translation-projects/922/',
      '/api/v1/translation-projects/923/',
      '/api/v1/translation-projects/924/',
      '/api/v1/translation-projects/925/',
      '/api/v1/translation-projects/926/',
      '/api/v1/translation-projects/927/',
      '/api/v1/translation-projects/928/',
      '/api/v1/translation-projects/929/',
      '/api/v1/translation-projects/930/',
      '/api/v1/translation-projects/931/',
      '/api/v1/translation-projects/932/',
      '/api/v1/translation-projects/933/',
      '/api/v1/translation-projects/934/',
      '/api/v1/translation-projects/935/',
      '/api/v1/translation-projects/936/',
      '/api/v1/translation-projects/937/',
      '/api/v1/translation-projects/938/',
      '/api/v1/translation-projects/939/',
      '/api/v1/translation-projects/940/',
      '/api/v1/translation-projects/941/',
      '/api/v1/translation-projects/942/',
      '/api/v1/translation-projects/943/',
      '/api/v1/translation-projects/944/',
      '/api/v1/translation-projects/945/',
      '/api/v1/translation-projects/946/',
      '/api/v1/translation-projects/947/',
      '/api/v1/translation-projects/948/',
      '/api/v1/translation-projects/949/',
      '/api/v1/translation-projects/950/',
      '/api/v1/translation-projects/951/',
      '/api/v1/translation-projects/952/',
      '/api/v1/translation-projects/953/',
      '/api/v1/translation-projects/954/',
      '/api/v1/translation-projects/955/',
      '/api/v1/translation-projects/956/',
      '/api/v1/translation-projects/957/',
      '/api/v1/translation-projects/958/',
      '/api/v1/translation-projects/959/',
      '/api/v1/translation-projects/960/',
      '/api/v1/translation-projects/961/',
      '/api/v1/translation-projects/962/',
      '/api/v1/translation-projects/963/',
      '/api/v1/translation-projects/964/',
      '/api/v1/translation-projects/965/',
      '/api/v1/translation-projects/966/',
      '/api/v1/translation-projects/967/',
      '/api/v1/translation-projects/968/',
      '/api/v1/translation-projects/986/',
      '/api/v1/translation-projects/987/',
      '/api/v1/translation-projects/988/',
      '/api/v1/translation-projects/1069/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '310',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.10',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/8/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/222/',
      '/api/v1/translation-projects/223/',
      '/api/v1/translation-projects/224/',
      '/api/v1/translation-projects/225/',
      '/api/v1/translation-projects/226/',
      '/api/v1/translation-projects/227/',
      '/api/v1/translation-projects/228/',
      '/api/v1/translation-projects/229/',
      '/api/v1/translation-projects/230/',
      '/api/v1/translation-projects/231/',
      '/api/v1/translation-projects/232/',
      '/api/v1/translation-projects/233/',
      '/api/v1/translation-projects/234/',
      '/api/v1/translation-projects/235/',
      '/api/v1/translation-projects/236/',
      '/api/v1/translation-projects/237/',
      '/api/v1/translation-projects/238/',
      '/api/v1/translation-projects/239/',
      '/api/v1/translation-projects/240/',
      '/api/v1/translation-projects/241/',
      '/api/v1/translation-projects/242/',
      '/api/v1/translation-projects/243/',
      '/api/v1/translation-projects/244/',
      '/api/v1/translation-projects/245/',
      '/api/v1/translation-projects/246/',
      '/api/v1/translation-projects/247/',
      '/api/v1/translation-projects/248/',
      '/api/v1/translation-projects/249/',
      '/api/v1/translation-projects/250/',
      '/api/v1/translation-projects/251/',
      '/api/v1/translation-projects/252/',
      '/api/v1/translation-projects/253/',
      '/api/v1/translation-projects/254/',
      '/api/v1/translation-projects/255/',
      '/api/v1/translation-projects/256/',
      '/api/v1/translation-projects/257/',
      '/api/v1/translation-projects/258/',
      '/api/v1/translation-projects/259/',
      '/api/v1/translation-projects/260/',
      '/api/v1/translation-projects/261/',
      '/api/v1/translation-projects/263/',
      '/api/v1/translation-projects/264/',
      '/api/v1/translation-projects/265/',
      '/api/v1/translation-projects/266/',
      '/api/v1/translation-projects/269/',
      '/api/v1/translation-projects/270/',
      '/api/v1/translation-projects/271/',
      '/api/v1/translation-projects/272/',
      '/api/v1/translation-projects/273/',
      '/api/v1/translation-projects/274/',
      '/api/v1/translation-projects/275/',
      '/api/v1/translation-projects/276/',
      '/api/v1/translation-projects/474/',
      '/api/v1/translation-projects/476/',
      '/api/v1/translation-projects/477/',
      '/api/v1/translation-projects/478/',
      '/api/v1/translation-projects/479/',
      '/api/v1/translation-projects/480/',
      '/api/v1/translation-projects/481/',
      '/api/v1/translation-projects/482/',
      '/api/v1/translation-projects/483/',
      '/api/v1/translation-projects/484/',
      '/api/v1/translation-projects/485/',
      '/api/v1/translation-projects/486/',
      '/api/v1/translation-projects/487/',
      '/api/v1/translation-projects/488/',
      '/api/v1/translation-projects/688/',
      '/api/v1/translation-projects/689/',
      '/api/v1/translation-projects/690/',
      '/api/v1/translation-projects/691/',
      '/api/v1/translation-projects/969/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '312',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.12',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/9/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/441/',
      '/api/v1/translation-projects/440/',
      '/api/v1/translation-projects/439/',
      '/api/v1/translation-projects/438/',
      '/api/v1/translation-projects/437/',
      '/api/v1/translation-projects/436/',
      '/api/v1/translation-projects/435/',
      '/api/v1/translation-projects/434/',
      '/api/v1/translation-projects/433/',
      '/api/v1/translation-projects/432/',
      '/api/v1/translation-projects/431/',
      '/api/v1/translation-projects/430/',
      '/api/v1/translation-projects/429/',
      '/api/v1/translation-projects/428/',
      '/api/v1/translation-projects/427/',
      '/api/v1/translation-projects/426/',
      '/api/v1/translation-projects/425/',
      '/api/v1/translation-projects/424/',
      '/api/v1/translation-projects/453/',
      '/api/v1/translation-projects/422/',
      '/api/v1/translation-projects/421/',
      '/api/v1/translation-projects/420/',
      '/api/v1/translation-projects/419/',
      '/api/v1/translation-projects/418/',
      '/api/v1/translation-projects/417/',
      '/api/v1/translation-projects/416/',
      '/api/v1/translation-projects/415/',
      '/api/v1/translation-projects/414/',
      '/api/v1/translation-projects/413/',
      '/api/v1/translation-projects/412/',
      '/api/v1/translation-projects/411/',
      '/api/v1/translation-projects/410/',
      '/api/v1/translation-projects/409/',
      '/api/v1/translation-projects/408/',
      '/api/v1/translation-projects/407/',
      '/api/v1/translation-projects/406/',
      '/api/v1/translation-projects/404/',
      '/api/v1/translation-projects/403/',
      '/api/v1/translation-projects/454/',
      '/api/v1/translation-projects/400/',
      '/api/v1/translation-projects/442/',
      '/api/v1/translation-projects/443/',
      '/api/v1/translation-projects/444/',
      '/api/v1/translation-projects/445/',
      '/api/v1/translation-projects/446/',
      '/api/v1/translation-projects/447/',
      '/api/v1/translation-projects/448/',
      '/api/v1/translation-projects/683/',
      '/api/v1/translation-projects/585/',
      '/api/v1/translation-projects/451/',
      '/api/v1/translation-projects/455/',
      '/api/v1/translation-projects/468/',
      '/api/v1/translation-projects/489/',
      '/api/v1/translation-projects/458/',
      '/api/v1/translation-projects/459/',
      '/api/v1/translation-projects/460/',
      '/api/v1/translation-projects/461/',
      '/api/v1/translation-projects/462/',
      '/api/v1/translation-projects/463/',
      '/api/v1/translation-projects/464/',
      '/api/v1/translation-projects/465/',
      '/api/v1/translation-projects/466/',
      '/api/v1/translation-projects/467/',
      '/api/v1/translation-projects/469/',
      '/api/v1/translation-projects/470/',
      '/api/v1/translation-projects/471/',
      '/api/v1/translation-projects/675/',
      '/api/v1/translation-projects/676/',
      '/api/v1/translation-projects/677/',
      '/api/v1/translation-projects/678/',
      '/api/v1/translation-projects/687/',
      '/api/v1/translation-projects/891/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '314',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.14',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/11/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/510/',
      '/api/v1/translation-projects/511/',
      '/api/v1/translation-projects/512/',
      '/api/v1/translation-projects/513/',
      '/api/v1/translation-projects/514/',
      '/api/v1/translation-projects/515/',
      '/api/v1/translation-projects/516/',
      '/api/v1/translation-projects/517/',
      '/api/v1/translation-projects/518/',
      '/api/v1/translation-projects/519/',
      '/api/v1/translation-projects/520/',
      '/api/v1/translation-projects/521/',
      '/api/v1/translation-projects/523/',
      '/api/v1/translation-projects/524/',
      '/api/v1/translation-projects/526/',
      '/api/v1/translation-projects/527/',
      '/api/v1/translation-projects/528/',
      '/api/v1/translation-projects/529/',
      '/api/v1/translation-projects/530/',
      '/api/v1/translation-projects/531/',
      '/api/v1/translation-projects/532/',
      '/api/v1/translation-projects/533/',
      '/api/v1/translation-projects/534/',
      '/api/v1/translation-projects/535/',
      '/api/v1/translation-projects/536/',
      '/api/v1/translation-projects/537/',
      '/api/v1/translation-projects/538/',
      '/api/v1/translation-projects/539/',
      '/api/v1/translation-projects/540/',
      '/api/v1/translation-projects/541/',
      '/api/v1/translation-projects/580/',
      '/api/v1/translation-projects/543/',
      '/api/v1/translation-projects/803/',
      '/api/v1/translation-projects/545/',
      '/api/v1/translation-projects/546/',
      '/api/v1/translation-projects/547/',
      '/api/v1/translation-projects/548/',
      '/api/v1/translation-projects/579/',
      '/api/v1/translation-projects/550/',
      '/api/v1/translation-projects/582/',
      '/api/v1/translation-projects/552/',
      '/api/v1/translation-projects/553/',
      '/api/v1/translation-projects/554/',
      '/api/v1/translation-projects/555/',
      '/api/v1/translation-projects/556/',
      '/api/v1/translation-projects/557/',
      '/api/v1/translation-projects/558/',
      '/api/v1/translation-projects/559/',
      '/api/v1/translation-projects/560/',
      '/api/v1/translation-projects/561/',
      '/api/v1/translation-projects/562/',
      '/api/v1/translation-projects/563/',
      '/api/v1/translation-projects/564/',
      '/api/v1/translation-projects/565/',
      '/api/v1/translation-projects/566/',
      '/api/v1/translation-projects/567/',
      '/api/v1/translation-projects/568/',
      '/api/v1/translation-projects/569/',
      '/api/v1/translation-projects/570/',
      '/api/v1/translation-projects/571/',
      '/api/v1/translation-projects/572/',
      '/api/v1/translation-projects/573/',
      '/api/v1/translation-projects/574/',
      '/api/v1/translation-projects/575/',
      '/api/v1/translation-projects/576/',
      '/api/v1/translation-projects/577/',
      '/api/v1/translation-projects/594/',
      '/api/v1/translation-projects/601/',
      '/api/v1/translation-projects/598/',
      '/api/v1/translation-projects/599/',
      '/api/v1/translation-projects/685/',
      '/api/v1/translation-projects/804/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '316',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.16',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/12/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/604/',
      '/api/v1/translation-projects/605/',
      '/api/v1/translation-projects/606/',
      '/api/v1/translation-projects/607/',
      '/api/v1/translation-projects/608/',
      '/api/v1/translation-projects/609/',
      '/api/v1/translation-projects/610/',
      '/api/v1/translation-projects/611/',
      '/api/v1/translation-projects/612/',
      '/api/v1/translation-projects/613/',
      '/api/v1/translation-projects/614/',
      '/api/v1/translation-projects/615/',
      '/api/v1/translation-projects/616/',
      '/api/v1/translation-projects/617/',
      '/api/v1/translation-projects/618/',
      '/api/v1/translation-projects/619/',
      '/api/v1/translation-projects/620/',
      '/api/v1/translation-projects/621/',
      '/api/v1/translation-projects/622/',
      '/api/v1/translation-projects/623/',
      '/api/v1/translation-projects/624/',
      '/api/v1/translation-projects/625/',
      '/api/v1/translation-projects/626/',
      '/api/v1/translation-projects/627/',
      '/api/v1/translation-projects/628/',
      '/api/v1/translation-projects/629/',
      '/api/v1/translation-projects/630/',
      '/api/v1/translation-projects/631/',
      '/api/v1/translation-projects/632/',
      '/api/v1/translation-projects/633/',
      '/api/v1/translation-projects/634/',
      '/api/v1/translation-projects/635/',
      '/api/v1/translation-projects/636/',
      '/api/v1/translation-projects/637/',
      '/api/v1/translation-projects/638/',
      '/api/v1/translation-projects/639/',
      '/api/v1/translation-projects/640/',
      '/api/v1/translation-projects/641/',
      '/api/v1/translation-projects/642/',
      '/api/v1/translation-projects/643/',
      '/api/v1/translation-projects/644/',
      '/api/v1/translation-projects/645/',
      '/api/v1/translation-projects/646/',
      '/api/v1/translation-projects/647/',
      '/api/v1/translation-projects/648/',
      '/api/v1/translation-projects/649/',
      '/api/v1/translation-projects/650/',
      '/api/v1/translation-projects/651/',
      '/api/v1/translation-projects/652/',
      '/api/v1/translation-projects/653/',
      '/api/v1/translation-projects/654/',
      '/api/v1/translation-projects/655/',
      '/api/v1/translation-projects/656/',
      '/api/v1/translation-projects/657/',
      '/api/v1/translation-projects/658/',
      '/api/v1/translation-projects/659/',
      '/api/v1/translation-projects/660/',
      '/api/v1/translation-projects/661/',
      '/api/v1/translation-projects/662/',
      '/api/v1/translation-projects/674/',
      '/api/v1/translation-projects/664/',
      '/api/v1/translation-projects/665/',
      '/api/v1/translation-projects/666/',
      '/api/v1/translation-projects/667/',
      '/api/v1/translation-projects/668/',
      '/api/v1/translation-projects/669/',
      '/api/v1/translation-projects/670/',
      '/api/v1/translation-projects/671/',
      '/api/v1/translation-projects/672/',
      '/api/v1/translation-projects/673/',
      '/api/v1/translation-projects/686/',
      '/api/v1/translation-projects/800/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '318',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.18',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/13/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/692/',
      '/api/v1/translation-projects/693/',
      '/api/v1/translation-projects/694/',
      '/api/v1/translation-projects/695/',
      '/api/v1/translation-projects/696/',
      '/api/v1/translation-projects/697/',
      '/api/v1/translation-projects/698/',
      '/api/v1/translation-projects/699/',
      '/api/v1/translation-projects/700/',
      '/api/v1/translation-projects/701/',
      '/api/v1/translation-projects/702/',
      '/api/v1/translation-projects/703/',
      '/api/v1/translation-projects/704/',
      '/api/v1/translation-projects/705/',
      '/api/v1/translation-projects/706/',
      '/api/v1/translation-projects/707/',
      '/api/v1/translation-projects/708/',
      '/api/v1/translation-projects/709/',
      '/api/v1/translation-projects/710/',
      '/api/v1/translation-projects/778/',
      '/api/v1/translation-projects/784/',
      '/api/v1/translation-projects/714/',
      '/api/v1/translation-projects/767/',
      '/api/v1/translation-projects/771/',
      '/api/v1/translation-projects/775/',
      '/api/v1/translation-projects/772/',
      '/api/v1/translation-projects/783/',
      '/api/v1/translation-projects/777/',
      '/api/v1/translation-projects/721/',
      '/api/v1/translation-projects/769/',
      '/api/v1/translation-projects/723/',
      '/api/v1/translation-projects/724/',
      '/api/v1/translation-projects/725/',
      '/api/v1/translation-projects/763/',
      '/api/v1/translation-projects/727/',
      '/api/v1/translation-projects/728/',
      '/api/v1/translation-projects/729/',
      '/api/v1/translation-projects/730/',
      '/api/v1/translation-projects/774/',
      '/api/v1/translation-projects/779/',
      '/api/v1/translation-projects/766/',
      '/api/v1/translation-projects/734/',
      '/api/v1/translation-projects/782/',
      '/api/v1/translation-projects/736/',
      '/api/v1/translation-projects/768/',
      '/api/v1/translation-projects/738/',
      '/api/v1/translation-projects/739/',
      '/api/v1/translation-projects/740/',
      '/api/v1/translation-projects/741/',
      '/api/v1/translation-projects/742/',
      '/api/v1/translation-projects/743/',
      '/api/v1/translation-projects/744/',
      '/api/v1/translation-projects/745/',
      '/api/v1/translation-projects/746/',
      '/api/v1/translation-projects/747/',
      '/api/v1/translation-projects/776/',
      '/api/v1/translation-projects/770/',
      '/api/v1/translation-projects/781/',
      '/api/v1/translation-projects/764/',
      '/api/v1/translation-projects/752/',
      '/api/v1/translation-projects/753/',
      '/api/v1/translation-projects/765/',
      '/api/v1/translation-projects/780/',
      '/api/v1/translation-projects/756/',
      '/api/v1/translation-projects/757/',
      '/api/v1/translation-projects/758/',
      '/api/v1/translation-projects/773/',
      '/api/v1/translation-projects/760/',
      '/api/v1/translation-projects/761/',
      '/api/v1/translation-projects/762/',
      '/api/v1/translation-projects/785/',
      '/api/v1/translation-projects/801/',
      '/api/v1/translation-projects/814/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => '32',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.2',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/3/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/83/',
      '/api/v1/translation-projects/81/',
      '/api/v1/translation-projects/80/',
      '/api/v1/translation-projects/79/',
      '/api/v1/translation-projects/77/',
      '/api/v1/translation-projects/76/',
      '/api/v1/translation-projects/75/',
      '/api/v1/translation-projects/74/',
      '/api/v1/translation-projects/73/',
      '/api/v1/translation-projects/72/',
      '/api/v1/translation-projects/71/',
      '/api/v1/translation-projects/39/',
      '/api/v1/translation-projects/40/',
      '/api/v1/translation-projects/41/',
      '/api/v1/translation-projects/42/',
      '/api/v1/translation-projects/43/',
      '/api/v1/translation-projects/44/',
      '/api/v1/translation-projects/45/',
      '/api/v1/translation-projects/46/',
      '/api/v1/translation-projects/47/',
      '/api/v1/translation-projects/48/',
      '/api/v1/translation-projects/49/',
      '/api/v1/translation-projects/50/',
      '/api/v1/translation-projects/51/',
      '/api/v1/translation-projects/52/',
      '/api/v1/translation-projects/53/',
      '/api/v1/translation-projects/54/',
      '/api/v1/translation-projects/55/',
      '/api/v1/translation-projects/56/',
      '/api/v1/translation-projects/57/',
      '/api/v1/translation-projects/58/',
      '/api/v1/translation-projects/59/',
      '/api/v1/translation-projects/60/',
      '/api/v1/translation-projects/61/',
      '/api/v1/translation-projects/62/',
      '/api/v1/translation-projects/63/',
      '/api/v1/translation-projects/64/',
      '/api/v1/translation-projects/65/',
      '/api/v1/translation-projects/66/',
      '/api/v1/translation-projects/67/',
      '/api/v1/translation-projects/68/',
      '/api/v1/translation-projects/277/',
      '/api/v1/translation-projects/278/',
      '/api/v1/translation-projects/279/',
      '/api/v1/translation-projects/280/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => '34',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.4',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/5/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/107/',
      '/api/v1/translation-projects/106/',
      '/api/v1/translation-projects/105/',
      '/api/v1/translation-projects/104/',
      '/api/v1/translation-projects/103/',
      '/api/v1/translation-projects/102/',
      '/api/v1/translation-projects/101/',
      '/api/v1/translation-projects/100/',
      '/api/v1/translation-projects/99/',
      '/api/v1/translation-projects/98/',
      '/api/v1/translation-projects/97/',
      '/api/v1/translation-projects/96/',
      '/api/v1/translation-projects/95/',
      '/api/v1/translation-projects/94/',
      '/api/v1/translation-projects/93/',
      '/api/v1/translation-projects/92/',
      '/api/v1/translation-projects/91/',
      '/api/v1/translation-projects/90/',
      '/api/v1/translation-projects/89/',
      '/api/v1/translation-projects/88/',
      '/api/v1/translation-projects/87/',
      '/api/v1/translation-projects/86/',
      '/api/v1/translation-projects/85/',
      '/api/v1/translation-projects/84/',
      '/api/v1/translation-projects/82/',
      '/api/v1/translation-projects/108/',
      '/api/v1/translation-projects/109/',
      '/api/v1/translation-projects/110/',
      '/api/v1/translation-projects/111/',
      '/api/v1/translation-projects/112/',
      '/api/v1/translation-projects/113/',
      '/api/v1/translation-projects/114/',
      '/api/v1/translation-projects/115/',
      '/api/v1/translation-projects/116/',
      '/api/v1/translation-projects/117/',
      '/api/v1/translation-projects/118/',
      '/api/v1/translation-projects/119/',
      '/api/v1/translation-projects/120/',
      '/api/v1/translation-projects/121/',
      '/api/v1/translation-projects/122/',
      '/api/v1/translation-projects/123/',
      '/api/v1/translation-projects/124/',
      '/api/v1/translation-projects/125/',
      '/api/v1/translation-projects/126/',
      '/api/v1/translation-projects/281/',
      '/api/v1/translation-projects/282/',
      '/api/v1/translation-projects/283/',
      '/api/v1/translation-projects/284/',
      '/api/v1/translation-projects/602/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => '36',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.6',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/6/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/127/',
      '/api/v1/translation-projects/128/',
      '/api/v1/translation-projects/129/',
      '/api/v1/translation-projects/130/',
      '/api/v1/translation-projects/131/',
      '/api/v1/translation-projects/132/',
      '/api/v1/translation-projects/133/',
      '/api/v1/translation-projects/134/',
      '/api/v1/translation-projects/135/',
      '/api/v1/translation-projects/136/',
      '/api/v1/translation-projects/137/',
      '/api/v1/translation-projects/138/',
      '/api/v1/translation-projects/139/',
      '/api/v1/translation-projects/140/',
      '/api/v1/translation-projects/141/',
      '/api/v1/translation-projects/142/',
      '/api/v1/translation-projects/143/',
      '/api/v1/translation-projects/144/',
      '/api/v1/translation-projects/145/',
      '/api/v1/translation-projects/146/',
      '/api/v1/translation-projects/147/',
      '/api/v1/translation-projects/148/',
      '/api/v1/translation-projects/149/',
      '/api/v1/translation-projects/150/',
      '/api/v1/translation-projects/151/',
      '/api/v1/translation-projects/152/',
      '/api/v1/translation-projects/153/',
      '/api/v1/translation-projects/154/',
      '/api/v1/translation-projects/155/',
      '/api/v1/translation-projects/156/',
      '/api/v1/translation-projects/157/',
      '/api/v1/translation-projects/158/',
      '/api/v1/translation-projects/159/',
      '/api/v1/translation-projects/160/',
      '/api/v1/translation-projects/161/',
      '/api/v1/translation-projects/162/',
      '/api/v1/translation-projects/163/',
      '/api/v1/translation-projects/164/',
      '/api/v1/translation-projects/165/',
      '/api/v1/translation-projects/166/',
      '/api/v1/translation-projects/167/',
      '/api/v1/translation-projects/168/',
      '/api/v1/translation-projects/169/',
      '/api/v1/translation-projects/170/',
      '/api/v1/translation-projects/171/',
      '/api/v1/translation-projects/172/',
      '/api/v1/translation-projects/267/',
      '/api/v1/translation-projects/285/',
      '/api/v1/translation-projects/286/',
      '/api/v1/translation-projects/287/',
      '/api/v1/translation-projects/288/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => '38',
    'description' => '',
    'fullname' => '(obsolete) Koha 3.8',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/7/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/173/',
      '/api/v1/translation-projects/174/',
      '/api/v1/translation-projects/175/',
      '/api/v1/translation-projects/176/',
      '/api/v1/translation-projects/177/',
      '/api/v1/translation-projects/178/',
      '/api/v1/translation-projects/179/',
      '/api/v1/translation-projects/180/',
      '/api/v1/translation-projects/181/',
      '/api/v1/translation-projects/182/',
      '/api/v1/translation-projects/184/',
      '/api/v1/translation-projects/185/',
      '/api/v1/translation-projects/186/',
      '/api/v1/translation-projects/187/',
      '/api/v1/translation-projects/188/',
      '/api/v1/translation-projects/189/',
      '/api/v1/translation-projects/190/',
      '/api/v1/translation-projects/191/',
      '/api/v1/translation-projects/192/',
      '/api/v1/translation-projects/193/',
      '/api/v1/translation-projects/194/',
      '/api/v1/translation-projects/195/',
      '/api/v1/translation-projects/196/',
      '/api/v1/translation-projects/197/',
      '/api/v1/translation-projects/198/',
      '/api/v1/translation-projects/199/',
      '/api/v1/translation-projects/200/',
      '/api/v1/translation-projects/201/',
      '/api/v1/translation-projects/202/',
      '/api/v1/translation-projects/203/',
      '/api/v1/translation-projects/204/',
      '/api/v1/translation-projects/205/',
      '/api/v1/translation-projects/206/',
      '/api/v1/translation-projects/207/',
      '/api/v1/translation-projects/208/',
      '/api/v1/translation-projects/209/',
      '/api/v1/translation-projects/210/',
      '/api/v1/translation-projects/211/',
      '/api/v1/translation-projects/212/',
      '/api/v1/translation-projects/213/',
      '/api/v1/translation-projects/214/',
      '/api/v1/translation-projects/215/',
      '/api/v1/translation-projects/216/',
      '/api/v1/translation-projects/217/',
      '/api/v1/translation-projects/218/',
      '/api/v1/translation-projects/219/',
      '/api/v1/translation-projects/220/',
      '/api/v1/translation-projects/221/',
      '/api/v1/translation-projects/268/',
      '/api/v1/translation-projects/289/',
      '/api/v1/translation-projects/290/',
      '/api/v1/translation-projects/505/',
      '/api/v1/translation-projects/490/',
      '/api/v1/translation-projects/492/',
      '/api/v1/translation-projects/493/',
      '/api/v1/translation-projects/494/',
      '/api/v1/translation-projects/495/',
      '/api/v1/translation-projects/496/',
      '/api/v1/translation-projects/497/',
      '/api/v1/translation-projects/498/',
      '/api/v1/translation-projects/499/',
      '/api/v1/translation-projects/500/',
      '/api/v1/translation-projects/501/',
      '/api/v1/translation-projects/502/',
      '/api/v1/translation-projects/503/',
      '/api/v1/translation-projects/504/',
      '/api/v1/translation-projects/679/',
      '/api/v1/translation-projects/680/',
      '/api/v1/translation-projects/681/',
      '/api/v1/translation-projects/682/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man1605',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 16.05',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/24/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/1072/',
      '/api/v1/translation-projects/1073/',
      '/api/v1/translation-projects/1074/',
      '/api/v1/translation-projects/1075/',
      '/api/v1/translation-projects/1076/',
      '/api/v1/translation-projects/1077/',
      '/api/v1/translation-projects/1078/',
      '/api/v1/translation-projects/1079/',
      '/api/v1/translation-projects/1080/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man1611',
    'description' => '',
    'fullname' => 'Koha manual 16.11',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/27/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/1247/',
      '/api/v1/translation-projects/1248/',
      '/api/v1/translation-projects/1249/',
      '/api/v1/translation-projects/1256/',
      '/api/v1/translation-projects/1251/',
      '/api/v1/translation-projects/1255/',
      '/api/v1/translation-projects/1253/',
      '/api/v1/translation-projects/1254/',
      '/api/v1/translation-projects/1257/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man1705',
    'description' => '',
    'fullname' => 'Koha manual 17.05',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/28/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/1258/',
      '/api/v1/translation-projects/1259/',
      '/api/v1/translation-projects/1260/',
      '/api/v1/translation-projects/1261/',
      '/api/v1/translation-projects/1262/',
      '/api/v1/translation-projects/1263/',
      '/api/v1/translation-projects/1264/',
      '/api/v1/translation-projects/1265/',
      '/api/v1/translation-projects/1266/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man314',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 3.14',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/16/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/787/',
      '/api/v1/translation-projects/788/',
      '/api/v1/translation-projects/789/',
      '/api/v1/translation-projects/790/',
      '/api/v1/translation-projects/791/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man316',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 3.16',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/17/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/792/',
      '/api/v1/translation-projects/793/',
      '/api/v1/translation-projects/794/',
      '/api/v1/translation-projects/795/',
      '/api/v1/translation-projects/796/',
      '/api/v1/translation-projects/798/',
      '/api/v1/translation-projects/805/',
      '/api/v1/translation-projects/1082/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man318',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 3.18',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/18/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/806/',
      '/api/v1/translation-projects/807/',
      '/api/v1/translation-projects/808/',
      '/api/v1/translation-projects/809/',
      '/api/v1/translation-projects/811/',
      '/api/v1/translation-projects/812/',
      '/api/v1/translation-projects/813/',
      '/api/v1/translation-projects/889/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man320',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 3.20',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/22/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/978/',
      '/api/v1/translation-projects/979/',
      '/api/v1/translation-projects/980/',
      '/api/v1/translation-projects/981/',
      '/api/v1/translation-projects/982/',
      '/api/v1/translation-projects/983/',
      '/api/v1/translation-projects/984/',
      '/api/v1/translation-projects/985/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'man322',
    'description' => '<p>You can access current formats at <a href="http://translate.koha-community.org/manual/">http://translate.koha-community.org/manual/</a></p>',
    'fullname' => 'Koha manual 3.22',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/21/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/970/',
      '/api/v1/translation-projects/971/',
      '/api/v1/translation-projects/972/',
      '/api/v1/translation-projects/973/',
      '/api/v1/translation-projects/974/',
      '/api/v1/translation-projects/975/',
      '/api/v1/translation-projects/976/',
      '/api/v1/translation-projects/977/',
      '/api/v1/translation-projects/1081/'
    ],
    'treestyle' => 'nongnu'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'marc21',
    'description' => '<p>Interim project to test translation of frameworks and other sql files for MARC21<br>

Translated files for this project can be downloaded from <br><b><a href="http://translate.koha-community.org/files/">http://translate.koha-community.org/files/</a></b><br>
They are re-regenerated periodically.
</p>',
    'fullname' => 'MARC21 SQL Files',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/10/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/588/',
      '/api/v1/translation-projects/508/',
      '/api/v1/translation-projects/509/',
      '/api/v1/translation-projects/583/',
      '/api/v1/translation-projects/507/',
      '/api/v1/translation-projects/587/',
      '/api/v1/translation-projects/589/',
      '/api/v1/translation-projects/590/',
      '/api/v1/translation-projects/591/',
      '/api/v1/translation-projects/592/',
      '/api/v1/translation-projects/597/',
      '/api/v1/translation-projects/603/',
      '/api/v1/translation-projects/888/'
    ],
    'treestyle' => 'auto'
  },
  {
    'checkstyle' => 'standard',
    'code' => 'terminology',
    'description' => '',
    'fullname' => 'Terminology',
    'ignoredfiles' => '',
    'localfiletype' => 'po',
    'resource_uri' => '/api/v1/projects/4/',
    'source_language' => '/api/v1/languages/2/',
    'translation_projects' => [
      '/api/v1/translation-projects/70/',
      '/api/v1/translation-projects/69/',
      '/api/v1/translation-projects/293/',
      '/api/v1/translation-projects/294/',
      '/api/v1/translation-projects/295/',
      '/api/v1/translation-projects/296/',
      '/api/v1/translation-projects/297/',
      '/api/v1/translation-projects/298/',
      '/api/v1/translation-projects/299/',
      '/api/v1/translation-projects/300/',
      '/api/v1/translation-projects/301/',
      '/api/v1/translation-projects/303/',
      '/api/v1/translation-projects/304/',
      '/api/v1/translation-projects/305/',
      '/api/v1/translation-projects/306/',
      '/api/v1/translation-projects/307/',
      '/api/v1/translation-projects/308/',
      '/api/v1/translation-projects/309/',
      '/api/v1/translation-projects/310/',
      '/api/v1/translation-projects/311/',
      '/api/v1/translation-projects/312/',
      '/api/v1/translation-projects/313/',
      '/api/v1/translation-projects/315/',
      '/api/v1/translation-projects/316/',
      '/api/v1/translation-projects/317/',
      '/api/v1/translation-projects/319/',
      '/api/v1/translation-projects/321/',
      '/api/v1/translation-projects/322/',
      '/api/v1/translation-projects/323/',
      '/api/v1/translation-projects/324/',
      '/api/v1/translation-projects/325/',
      '/api/v1/translation-projects/326/',
      '/api/v1/translation-projects/327/',
      '/api/v1/translation-projects/330/',
      '/api/v1/translation-projects/331/',
      '/api/v1/translation-projects/332/',
      '/api/v1/translation-projects/333/',
      '/api/v1/translation-projects/334/',
      '/api/v1/translation-projects/336/',
      '/api/v1/translation-projects/337/',
      '/api/v1/translation-projects/339/',
      '/api/v1/translation-projects/340/',
      '/api/v1/translation-projects/341/',
      '/api/v1/translation-projects/342/',
      '/api/v1/translation-projects/343/',
      '/api/v1/translation-projects/344/',
      '/api/v1/translation-projects/345/',
      '/api/v1/translation-projects/346/',
      '/api/v1/translation-projects/600/',
      '/api/v1/translation-projects/593/',
      '/api/v1/translation-projects/684/',
      '/api/v1/translation-projects/799/',
      '/api/v1/translation-projects/1164/'
    ],
    'treestyle' => 'auto'
  }
];

1;
