package WordList::ZH::HSK4;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words",600,"num_words_contains_unicode",600,"num_words_contains_whitespace",0,"avg_word_len",1.85833333333333,"num_words_contains_nonword_chars",0,"longest_word_len",4,"shortest_word_len",1); # STATS

1;
# ABSTRACT: HSK (level 4 only) words

=pod

=encoding UTF-8

=head1 NAME

WordList::ZH::HSK4 - HSK (level 4 only) words

=head1 VERSION

This document describes version 0.01 of WordList::ZH::HSK4 (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::ZH::HSK4;

 my $wl = WordList::ZH::HSK4->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 1.85833333333333 |
 | longest_word_len                 | 4                |
 | num_words                        | 600              |
 | num_words_contains_nonword_chars | 0                |
 | num_words_contains_unicode       | 600              |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 1                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<WordList::ZH::HSK>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一切
不仅
不得不
不管
不过
与
专业
专门
世纪
丢
严格
严重
丰富
主意
举
举办
举行
之
乒乓球
乘坐
也许
乱
于是
云
互相
互联网
亚洲
交
交流
交通
京剧
亲戚
仍然
从来
仔细
付款
以
以为
价格
任何
任务
份
优点
优秀
传真
伤心
估计
低
作家
作用
作者
使
使用
例如
保护
保证
信封
信心
信息
俩
修理
倍
倒
值得
假
停
偶尔
儿童
允许
光
免费
入口
全部
公里
共同
关键
兴奋
其中
其次
养成
内
内容
冷静
准时
准确
凉快
减少
减肥
出发
出差
出现
出生
刀
刚
判断
到处
到底
剩
力气
功夫
加油站
加班
动作
勇敢
勺子
包子
区别
十分
千万
博士
占线
卫生间
印象
危险
即使
却
厉害
压力
厕所
厚
原因
原来
原谅
厨房
参观
及时
友好
友谊
反对
发展
发生
取
受不了
受到
另外
只好
只要
可怜
可惜
可是
台
叶子
号码
吃惊
各
合格
合适
同情
同时
后悔
否则
吸引
呀
周围
味道
咱们
咳嗽
咸
响
售货员
商量
回忆
因此
困
困难
国籍
国际
地址
地点
地球
场
坚持
垃圾桶
基础
堵车
塑料袋
填空
增加
复印
复杂
够
大使馆
大夫
大概
大约
失望
失败
奖金
好像
好处
存
孙子
学期
安全
安排
完全
实在
实际
客厅
害羞
家具
寄
密码
富
寒假
对于
对话
对面
导游
将来
尊重
小伙子
小吃
小说
尝
尤其
尽管
工资
左右
巧克力
差不多
帅
师傅
干
干杯
平时
年龄
并且
幸福
幽默
广告
广播
应聘
底
座
座位
建议
开心
开玩笑
弄
引起
弹钢琴
当
当时
往往
律师
得
得意
心情
怀疑
态度
性别
性格
总结
恐怕
情
情况
愉快
意见
感动
感情
感觉
感谢
懒
成为
成功
戴
房东
所有
打印
打扮
打扰
打折
打招呼
打针
扔
批评
技术
护士
报名
抬
抱
抱歉
抽烟
拉
拒绝
招聘
挂
指
按时
按照
挺
掉
排列
排队
接受
接着
推
推迟
提
提供
提前
提醒
擦
支持
收
收入
收拾
改变
放弃
放暑假
放松
故意
效果
教授
教育
敢
散步
数字
数量
敲
整理
文章
方向
方法
方面
旅行
无
无聊
无论
既然
日记
是否
普通话
普遍
景色
暂时
暖和
最好
有趣
本来
杂志
材料
条件
来不及
来得及
来自
果汁
标准
样子
桥
梦
棒
森林
棵
植物
橡皮
正好
正常
正式
正确
死
母亲
比如
毕业
毛
毛巾
民族
气候
永远
汗
污染
汤
沙发
法律
活动
活泼
流利
流行
浪漫
浪费
海洋
消息
深
温度
满
演出
演员
激动
火
烤鸭
烦恼
热闹
然而
照
熟悉
父亲
牙膏
特点
猜
现金
理发
理想
理解
甚至
生命
生意
生活
由
由于
申请
留
登机牌
百分之
皮肤
盐
盒子
目的
直接
相反
相同
省
看法
真正
眼镜
知识
短信
矿泉水
研究
破
硕士
确实
礼拜天
礼貌
社会
祝贺
禁止
科学
秒
租
积极
积累
稍微
究竟
穷
空
空气
窗户
竞争
竟然
笑话
符合
笨
等
答案
签证
管理
篇
粗心
精彩
糖
紧张
约会
经历
经济
经验
结果
继续
缺少
缺点
网球
网站
美丽
羡慕
羽毛球
翻译
老虎
考虑
而
耐心
职业
联系
聚会
肚子
肯定
胳膊
能力
脏
脱
脾气
自信
自然
至少
航班
艺术
节
节约
苦
获得
著名
葡萄
行
表扬
表格
表演
表示
袜子
西红柿
要是
观众
规定
解释
警察
计划
讨厌
讨论
记者
许多
证明
词语
诚实
详细
语法
语言
误会
说明
调查
谈
负责
责任
质量
购物
赚
赢
赶
超过
趟
距离
躺
转
轻
轻松
输
辛苦
辣
过程
进行
连
迷路
适合
适应
通知
通过
逛
速度
遍
道歉
邀请
邮局
郊区
部分
酸
醒
重
重新
重点
重视
钥匙
错误
镜子
长城
长江
阅读
阳光
降低
降落
陪
随便
随着
难受
难道
零钱
页
顺便
顺利
顺序
顾客
预习
餐厅
饺子
饼干
首先
首都
香
马虎
骄傲
骗
高速公路
麻烦
鼓励
