#!/usr/bin/env perl

# This script generates constants class for token type (Regexp::Lexer::TokenType)
# from `types.yaml`

use strict;
use warnings;
use utf8;
use FindBin;
use YAML::Tiny;

my $yaml = YAML::Tiny->read("$FindBin::Bin/types.yaml")->[0];

my $src = <<'...';
package Regexp::Lexer::TokenType;

# *** DO NOT EDIT THIS FILE DIRECTLY ***
# This file is generated by 'author/generate_token_type.pl'

use strict;
use warnings;
use utf8;

use constant {
...

my $type_value = 1;

my $normal_types = $yaml->{normal};
for my $normal_type (@$normal_types) {
    $src .= <<"...";
    $normal_type => {
        id => $type_value,
        name => '$normal_type',
    },
...
    $type_value++;
};

my $escaped_types = $yaml->{escaped};
for my $escaped_type (@$escaped_types) {
    $src .= <<"...";
    Escaped$escaped_type => {
        id => $type_value,
        name => 'Escaped$escaped_type',
    },
...
    $type_value++;
}

$src .= <<'...';
};

1;
__END__

=for stopwords EscapedCChar

=encoding utf-8

=head1 NAME

Regexp::Lexer::TokenType - Token types of Regexp::Lexer

=head1 DESCRIPTION

This module provides token types for L<Regexp::Lexer>.

Format of token type is bellow;

    {
        id => <ID of token>,
        name => <name of token>
    }

If you want to identify the token, I highly recommend you to use C<id>.

=head1 TYPES

=over 4

...

for my $normal_type (@$normal_types) {
    $src .= "=item * $normal_type\n\n";
}

for my $escaped_type (@$escaped_types) {
    $src .= "=item * Escaped$escaped_type\n\n";
}

$src .= <<'...';
=back

=head1 LICENSE

Copyright (C) moznion.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHOR

moznion E<lt>moznion@gmail.comE<gt>

=cut

...

my $package_file = "$FindBin::Bin/../lib/Regexp/Lexer/TokenType.pm";

open my $fh, '>', $package_file;
print ${fh} $src;

print "Generated!\n";

__END__

