package Yukki::Settings;
$Yukki::Settings::VERSION = '0.991_002'; # TRIAL

$Yukki::Settings::VERSION = '0.991002';use v5.24;
use utf8;
use Moo;

use Types::Path::Tiny qw( Path );
use Types::Standard qw( Str );
use Yukki::Settings::Repository;
use Yukki::Types qw( PrivilegesMap RepositoryMap YukkiSettingsAnonymous );

use namespace::clean;

# ABSTRACT: provides structure and validation to settings in yukki.conf


has root => (
    is          => 'ro',
    isa         => Path,
    required    => 1,
    coerce      => 1,
    default     => '.',
);


has repository_path => (
    is          => 'ro',
    isa         => Path,
    required    => 1,
    coerce      => 1,
    default     => 'repositories',
);


has user_path => (
    is          => 'ro',
    isa         => Path,
    required    => 1,
    coerce      => 1,
    default     => 'var/db/users',
);


has digest => (
    is          => 'ro',
    isa         => Str,
    required    => 1,
    default     => 'SHA-512',
);


has anonymous => (
    is          => 'ro',
    isa         => YukkiSettingsAnonymous,
    required    => 1,
    coerce      => 1,
    default     => sub { Yukki::Settings::Anonymous->new },
);


has repo_path => (
    is          => 'ro',
    isa         => Path,
    required    => 1,
    coerce      => 1,
    default     => 'var/db/repos',
);


has repositories => (
    is          => 'ro',
    isa         => RepositoryMap,
    required    => 1,
    coerce      => 1,
);

{
    package Yukki::Settings::Anonymous;
$Yukki::Settings::Anonymous::VERSION = '0.991_002'; # TRIAL

$Yukki::Settings::Anonymous::VERSION = '0.991002';use Moo;
    use Types::Standard qw( Str );
    use Yukki::Types qw( EmailAddress );

    has author_name => (
        is          => 'ro',
        isa         => Str,
        required    => 1,
        default     => 'Anonymous',
    );

    has author_email => (
        is          => 'ro',
        isa         => EmailAddress,
        required    => 1,
        coerce      => 1,
        default     => 'anonymous@localhost',
    );
}


has special_privileges => (
    is          => 'ro',
    isa         => PrivilegesMap,
    required    => 1,
    coerce      => 1,
    default     => sub { +{} },
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Yukki::Settings - provides structure and validation to settings in yukki.conf

=head1 VERSION

version 0.991_002

=head1 DESCRIPTION

This class provides structure for the main application configuration in L<Yukki>.

Yukki may fail to start unless your configuration is correct.

=head1 ATTRIBUTES

=head2 root

This is the wiki site directory. This should be the same folder that was given the F<yukki-setup> command. It works best if you make this an absolute path.

=head2 repository_path

This is the folder where Yukki will find the git repositories installed under C<root>. The default is F<root/repositories>.

=head2 user_path

This is the folder where the list of user files can be found.

=head2 digest

This is the name of the digest algorithm to use to store passwords. See L<Digest> for more information. The default is "SHA-512".

N.B. If you change digest algorithms, old passwords saved with the old digest algorithm will continue to work as long as the old digest algorithm class is still installed.

=head2 anonymous

This is a section configuring anonymous user information.

=over

=item author_name

This is the name to use when an anonymous user makes a change to a wiki repository.

=item author_email

This is the email address to use when an anonymous user makes a change to a wiki repository.

=back

=head2 repo_path

This is the folder where repository configuraiton files can be found. This path is intended for application managed repository configuration files. If you want to manage your repositories from the command-line instead, store the repository configurations under the C<repository> key in the main settings file.

=head2 repositories

This is a section under which each repository is configured. The keys under here are the name found in the URL. It is also the name to use when running the F<yukki-git-init> and other repository-related commands.

Repository configurations may be stored either in the main Yukki configuration file under the C<repositories> key or as individual files located in the directory named in the C<repo_path> key. If a configuration is named in both places, the one in the main settings file will always be used.

Each repository configuration should provide the following configruation keys.

=head2 special_privileges

This section of the settings configures which groups grant special privileges. These special privileges grant access to view or change the configuration from within the application. By default, no one has these privileges, effectively disabling any in-app administrative features.

The grants for each here are identical to that available to repositories:

=over

=item anonymous_access_level

This names the access level anonymous users have. Obviously, it would generally be unwise for this to be anything but "none" for adminsitrative functions, but "read" and "write" are other possible values.

=item read_groups

Names the list of groups that are granted permission to perform read-only actions. This may also be set to "ANY" to specify that any logged user may perform this action or "NONE" to specify that no logged user may perform this action.

=item write_groups

Names the list of groups that are granted permission to perform read-write actions. As with read, this may be set to "ANY" and "NONE" with the same meaning.

=back

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
