use Unicode::Collate::CJK::Pinyin;
+{
   locale_version => 1.31,
   overrideCJK => \&Unicode::Collate::CJK::Pinyin::weightPinyin,
   entry => <<'ENTRY', # for DUCET v13.0.0
0101      ; [.1FA2.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.1FA2.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.1FA2.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.1FA2.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.1FA2.001E.0002] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.1FA2.001E.0002] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.1FA2.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.1FA2.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.2007.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.2007.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.2007.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.2007.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.2007.001E.0002] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.2007.001E.0002] # LATIN SMALL LETTER E WITH CARON
011A      ; [.2007.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.2007.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.2007.0021.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.2007.0021.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.2007.0021.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.2007.0021.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.2007.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.2007.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.2007.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.2007.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.2007.0023.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.2007.0023.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.2007.0023.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.2007.0023.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.2007.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.2007.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.2007.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.2007.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.2007.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.2007.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.2007.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.2007.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.2007.0025.0002][.0000.002D.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.2007.0025.0008][.0000.002D.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.2007.0025.0002][.0000.003B.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.2007.0025.0008][.0000.003B.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.2007.0025.0002][.0000.0042.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.2007.0025.0008][.0000.0042.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.2090.001C.0002] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.2090.001C.0002] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.2090.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.2090.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.2090.001E.0002] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.2090.001E.0002] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.2090.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.2090.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.2109.001C.0002] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.2109.001C.0008] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.2109.001E.0002] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.2109.001E.0008] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.2109.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.2109.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.2109.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.2109.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.2118.001C.0002] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.2118.001C.0008] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.2118.001E.0002] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.2118.001E.0002] # LATIN SMALL LETTER N WITH CARON
0147      ; [.2118.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.2118.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.213C.001C.0002] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.213C.001C.0002] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.213C.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.213C.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.213C.001E.0002] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.213C.001E.0002] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.213C.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.213C.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.2217.001C.0002] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.2217.001C.0002] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.2217.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.2217.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.2217.001E.0002] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.2217.001E.0002] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.2217.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.2217.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.2217.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.2217.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.2217.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.2217.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.2217.0021.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.2217.0021.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.2217.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.2217.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.2217.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.2217.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.2217.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.2217.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.2217.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.2217.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.2217.0023.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.2217.0023.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.2217.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.2217.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.2217.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.2217.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.2217.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.2217.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.2217.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.2217.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 0041 ; [.8000.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER A>
FDD0 0042 ; [.80C5.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER B>
FDD0 0043 ; [.8441.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER C>
FDD0 0044 ; [.897D.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER D>
FDD0 0045 ; [.8D61.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER E>
FDD0 0046 ; [.8E1B.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER F>
FDD0 0047 ; [.9089.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER G>
FDD0 0048 ; [.93C4.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER H>
FDD0 004A ; [.97EC.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER J>
FDD0 004B ; [.9E32.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER K>
FDD0 004C ; [.A05D.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER L>
3007      ; [.A401.0020.0002] # IDEOGRAPHIC NUMBER ZERO
FDD0 004D ; [.A680.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER M>
FDD0 004E ; [.A9A9.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER N>
FDD0 004F ; [.AB89.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER O>
FDD0 0050 ; [.ABAC.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER P>
FDD0 0051 ; [.AE02.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER Q>
FDD0 0052 ; [.B1F1.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER R>
FDD0 0053 ; [.B337.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER S>
FDD0 0054 ; [.B858.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER T>
FDD0 0057 ; [.BBD3.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER W>
FDD0 0058 ; [.BE4A.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER X>
FDD0 0059 ; [.C382.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER Y>
FDD0 005A ; [.CB22.0020.0002] # <noncharacter-FDD0, LATIN CAPITAL LETTER Z>
3220      ; [*0328.0020.0004][.C5CF.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*0328.0020.0004][.AE03.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*0328.0020.0004][.B35F.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*0328.0020.0004][.9C92.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*0328.0020.0004][.8E0E.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*0328.0020.0004][.BDF1.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*0328.0020.0004][.89B6.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*0328.0020.0004][.AE82.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*0328.0020.0004][.C1F9.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*0328.0020.0004][.80C6.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*0328.0020.0004][.A49F.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*0328.0020.0004][.A132.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*0328.0020.0004][.B57B.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*0328.0020.0004][.C10A.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*0328.0020.0004][.A8EB.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*0328.0020.0004][.9589.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*0328.0020.0004][.B715.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*0328.0020.0004][.BB2D.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*0328.0020.0004][.C304.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*0328.0020.0004][.B272.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*0328.0020.0004][.CA96.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*0328.0020.0004][.C8D2.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*0328.0020.0004][.A98A.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*0328.0020.0004][.CF58.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*0328.0020.0004][.B6BA.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*0328.0020.0004][.97BC.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*0328.0020.0004][.B980.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*0328.0020.0004][.999B.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*0328.0020.0004][.B4AC.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*0328.0020.0004][.CFAD.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*0328.0020.0004][.98D6.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*0328.0020.0004][.D0D4.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*0328.0020.0004][.CE51.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*0328.0020.0004][.844F.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*0328.0020.0004][.D0A3.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*0328.0020.0004][.9B96.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.1F98.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.1F99.0020.0004][.1F98.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.1F99.0020.0004][.1F98.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.1F99.0020.0004][.1F98.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.1F99.0020.0004][.1F99.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.1F99.0020.0004][.1F99.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.1F99.0020.0004][.1F99.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.1F99.0020.0004][.1F9A.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.1F99.0020.0004][.1F9A.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.1F99.0020.0004][.1F9A.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.1F99.0020.0004][.1F9B.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.1F99.0020.0004][.1F9B.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.1F99.0020.0004][.1F9C.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.1F99.0020.0004][.1F9C.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.1F99.0020.0004][.1F9D.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.1F99.0020.0004][.1F9D.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.1F99.0020.0004][.1F9E.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.1F99.0020.0004][.1F9E.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.1F99.0020.0004][.1F9F.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.1F99.0020.0004][.1F9F.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.1F99.0020.0004][.1FA0.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.1F99.0020.0004][.1FA0.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.1F99.0020.0004][.1FA1.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.1F99.0020.0004][.1FA1.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.1F99.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.1F99.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.1F99.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.1F9A.0020.0004][.1F98.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.1F9A.0020.0004][.1F98.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.1F9A.0020.0004][.1F99.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.1F9A.0020.0004][.1F99.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.1F9A.0020.0004][.1F9A.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.1F9A.0020.0004][.1F9A.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.1F9A.0020.0004][.1F9B.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.1F9A.0020.0004][.1F9B.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.1F9A.0020.0004][.1F9C.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.1F9A.0020.0004][.1F9C.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.1F9A.0020.0004][.1F9D.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.1F9A.0020.0004][.1F9E.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.1F9A.0020.0004][.1F9F.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.1F9A.0020.0004][.1FA0.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.1F9A.0020.0004][.1FA1.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.1F9A.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.1F9A.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.1F9A.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.1F9B.0020.0004][.1F98.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.1F9B.0020.0004][.1F99.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.1F9B.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.1F9B.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.1F9B.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.1F9C.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.1F9C.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.1F9C.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.1F9D.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.1F9D.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.1F9D.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.1F9E.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.1F9E.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.1F9E.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.1F9F.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.1F9F.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.1F9F.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.1FA0.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.1FA0.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.1FA0.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.1FA1.0020.0004][.B272.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.1FA1.0020.0004][.CA96.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.1FA1.0020.0004][.8B60.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*038A.0020.0004][.B35F.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*038A.0020.0004][.8E0E.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*038A.0020.0004][.B548.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*038A.0020.0004][.8049.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*038A.0020.0004][.89A6.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*038A.0020.0004][.811B.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*038A.0020.0004][.81FC.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*038A.0020.0004][.8B60.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*038A.0020.0004][.8A91.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.C5CF.0020.0004] # KANGXI RADICAL ONE
3192      ; [.C5CF.0020.0014] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.C5CF.0020.0006] # CIRCLED IDEOGRAPH ONE
1F229     ; [.C5CF.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8BE6.0020.0014] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.AE03.0020.0006] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.B35F.0020.0014] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.B35F.0020.0006] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.B35F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.B46D.0020.0014] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.B46D.0020.0006] # CIRCLED IDEOGRAPH HIGH
3198      ; [.BF75.0020.0014] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.BF75.0020.0006] # CIRCLED IDEOGRAPH LOW
319B      ; [.8382.0020.0014] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.937A.0020.0004] # KANGXI RADICAL LINE
3197      ; [.CECC.0020.0014] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.CECC.0020.0006] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.CECC.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.CF8B.0020.0004] # KANGXI RADICAL DOT
2F03      ; [.AD44.0020.0004] # KANGXI RADICAL SLASH
2F04      ; [.C643.0020.0004] # KANGXI RADICAL SECOND
319A      ; [.C643.0020.0014] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.9C92.0020.0006] # CIRCLED IDEOGRAPH NINE
2F05      ; [.9D9D.0020.0004] # KANGXI RADICAL HOOK
2F06      ; [.8E0E.0020.0004] # KANGXI RADICAL TWO
3193      ; [.8E0E.0020.0014] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.8E0E.0020.0006] # CIRCLED IDEOGRAPH TWO
1F214     ; [.8E0E.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.BDF1.0020.0006] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.BAE9.0020.0004] # KANGXI RADICAL LID
1F218     ; [.9A8F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.B22F.0020.0004] # KANGXI RADICAL MAN
319F      ; [.B22F.0020.0014] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.AE82.0020.0006] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.C1F9.0020.0006] # CIRCLED IDEOGRAPH REST
329D      ; [.C8A5.0020.0006] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.8DE5.0020.0004] # KANGXI RADICAL LEGS
2F0A      ; [.B2E8.0020.0004] # KANGXI RADICAL ENTER
2F0B      ; [.80C6.0020.0004] # KANGXI RADICAL EIGHT
3287      ; [.80C6.0020.0006] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.A49F.0020.0006] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.9C60.0020.0004] # KANGXI RADICAL DOWN BOX
1F21E     ; [.CB49.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.A832.0020.0004] # KANGXI RADICAL COVER
32A2      ; [.C132.0020.0006] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.837B.0020.0004] # KANGXI RADICAL ICE
2F0F      ; [.989A.0020.0004] # KANGXI RADICAL TABLE
2F10      ; [.AF3D.0020.0004] # KANGXI RADICAL OPEN BOX
2F11      ; [.8A71.0020.0004] # KANGXI RADICAL KNIFE
1F220     ; [.8779.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.AF1F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.9162.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.A237.0020.0004] # KANGXI RADICAL POWER
3298      ; [.A132.0020.0006] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.8175.0020.0004] # KANGXI RADICAL WRAP
2F14      ; [.8238.0020.0004] # KANGXI RADICAL SPOON
2F15      ; [.8E8F.0020.0004] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.BF01.0020.0004] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.C5D4.0020.0006] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.B57B.0020.0004] # KANGXI RADICAL TEN
3038      ; [.B57B.0020.0004] # HANGZHOU NUMERAL TEN
3289      ; [.B57B.0020.0006] # CIRCLED IDEOGRAPH TEN
3039      ; [.AAA8.0020.0004] # HANGZHOU NUMERAL TWENTY
303A      ; [.B342.0020.0004] # HANGZHOU NUMERAL THIRTY
32AF      ; [.C10A.0020.0006] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.8410.0020.0004] # KANGXI RADICAL DIVINATION
2F19      ; [.9B2A.0020.0004] # KANGXI RADICAL SEAL
329E      ; [.C7AF.0020.0006] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.85AC.0020.0004] # KANGXI RADICAL CLIFF
2F1B      ; [.B6E4.0020.0004] # KANGXI RADICAL PRIVATE
2F1C      ; [.C8E8.0020.0004] # KANGXI RADICAL AGAIN
1F212     ; [.B6A1.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.9F2E.0020.0004] # KANGXI RADICAL MOUTH
1F251     ; [.9ED7.0020.0006] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.C8E9.0020.0006] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.C8E9.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.9499.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.A8EB.0020.0006] # CIRCLED IDEOGRAPH NAME
1F225     ; [.8816.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.BD6F.0020.0006] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.C804.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.BC8F.0020.0004] # KANGXI RADICAL ENCLOSURE
3195      ; [.B715.0020.0014] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.B715.0020.0006] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.BB2D.0020.0004] # KANGXI RADICAL EARTH
328F      ; [.BB2D.0020.0006] # CIRCLED IDEOGRAPH EARTH
319E      ; [.8AAF.0020.0014] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.B5A9.0020.0004] # KANGXI RADICAL SCHOLAR
1F224     ; [.B526.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.CE2D.0020.0004] # KANGXI RADICAL GO
2F22      ; [.B7D9.0020.0004] # KANGXI RADICAL GO SLOWLY
2F23      ; [.BE4B.0020.0004] # KANGXI RADICAL EVENING
1F215     ; [.8D1C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.C59A.0020.0006] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.89A7.0020.0004] # KANGXI RADICAL BIG
337D      ; [.89A7.0020.001C][.CDCB.0020.001C] # SQUARE ERA NAME TAISYOU
319D      ; [.B9F9.0020.0014] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.B9F9.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.AB5E.0020.0004] # KANGXI RADICAL WOMAN
329B      ; [.AB5E.0020.0006] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.D0E1.0020.0004] # KANGXI RADICAL CHILD
1F211     ; [.D0D3.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.C304.0020.0006] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.A858.0020.0004] # KANGXI RADICAL ROOF
32AA      ; [.D0E4.0020.0006] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.8955.0020.0004] # KANGXI RADICAL INCH
2F29      ; [.C0DE.0020.0004] # KANGXI RADICAL SMALL
2F2A      ; [.C8AC.0020.0004] # KANGXI RADICAL LAME
2F2B      ; [.B554.0020.0004] # KANGXI RADICAL CORPSE
2F2C      ; [.85F7.0020.0004] # KANGXI RADICAL SPROUT
2F2D      ; [.B3FD.0020.0004] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.87DC.0020.0004] # KANGXI RADICAL RIVER
2F2F      ; [.91CB.0020.0004] # KANGXI RADICAL WORK
32A7      ; [.D19D.0020.0006] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.D19D.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.989B.0020.0004] # KANGXI RADICAL ONESELF
2F31      ; [.9B91.0020.0004] # KANGXI RADICAL TURBAN
2F32      ; [.90EE.0020.0004] # KANGXI RADICAL DRY
337B      ; [.AD6D.0020.001C][.866D.0020.001C] # SQUARE ERA NAME HEISEI
2F33      ; [.C50D.0020.0004] # KANGXI RADICAL SHORT THREAD
3245      ; [.C8EA.0020.0006] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.9307.0020.0004] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.C792.0020.0004] # KANGXI RADICAL LONG STRIDE
2F36      ; [.91E7.0020.0004] # KANGXI RADICAL TWO HANDS
2F37      ; [.C66C.0020.0004] # KANGXI RADICAL SHOOT
2F38      ; [.91CC.0020.0004] # KANGXI RADICAL BOW
2F39      ; [.98AF.0020.0004] # KANGXI RADICAL SNOUT
2F3A      ; [.B3FE.0020.0004] # KANGXI RADICAL BRISTLE
2F3B      ; [.86F1.0020.0004] # KANGXI RADICAL STEP
1F21D     ; [.957C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.8AB1.0020.0006] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.C178.0020.0004] # KANGXI RADICAL HEART
2F3D      ; [.9153.0020.0004] # KANGXI RADICAL HALBERD
2F3E      ; [.95D9.0020.0004] # KANGXI RADICAL DOOR
2F3F      ; [.B60C.0020.0004] # KANGXI RADICAL HAND
1F210     ; [.B60C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.89A6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.BAEB.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.CE40.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.8420.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.CDDA.0020.0004] # KANGXI RADICAL BRANCH
2F41      ; [.ADCC.0020.0004] # KANGXI RADICAL RAP
2F42      ; [.BD44.0020.0004] # KANGXI RADICAL SCRIPT
3246      ; [.BD44.0020.0006] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8C5E.0020.0004] # KANGXI RADICAL DIPPER
1F21B     ; [.A385.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.9B93.0020.0004] # KANGXI RADICAL AXE
1F21F     ; [.C188.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8E90.0020.0004] # KANGXI RADICAL SQUARE
2F46      ; [.BDD2.0020.0004] # KANGXI RADICAL NOT
2F47      ; [.B272.0020.0004] # KANGXI RADICAL SUN
3290      ; [.B272.0020.0006] # CIRCLED IDEOGRAPH SUN
337E      ; [.A8EC.0020.001C][.CE5C.0020.001C] # SQUARE ERA NAME MEIZI
1F219     ; [.C83C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.CCD5.0020.001C][.949E.0020.001C] # SQUARE ERA NAME SYOUWA
2F48      ; [.CA8E.0020.0004] # KANGXI RADICAL SAY
2F49      ; [.CA96.0020.0004] # KANGXI RADICAL MOON
328A      ; [.CA96.0020.0006] # CIRCLED IDEOGRAPH MOON
1F237     ; [.CA96.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.C8D2.0020.0006] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.C8D2.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.A98A.0020.0004] # KANGXI RADICAL TREE
328D      ; [.A98A.0020.0006] # CIRCLED IDEOGRAPH WOOD
3291      ; [.CF58.0020.0006] # CIRCLED IDEOGRAPH STOCK
337F      ; [.CF58.0020.001C][.B5B3.0020.001C][.9737.0020.001C][.B4AC.0020.001C] # SQUARE CORPORATION
2F4B      ; [.AF4C.0020.0004] # KANGXI RADICAL LACK
2F4C      ; [.CE2E.0020.0004] # KANGXI RADICAL STOP
32A3      ; [.CDCB.0020.0006] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.89B3.0020.0004] # KANGXI RADICAL DEATH
2F4E      ; [.B623.0020.0004] # KANGXI RADICAL WEAPON
2F4F      ; [.BDD3.0020.0004] # KANGXI RADICAL DO NOT
2E9F      ; [.A97A.0020.0004] # CJK RADICAL MOTHER
2F50      ; [.8239.0020.0004] # KANGXI RADICAL COMPARE
2F51      ; [.A71D.0020.0004] # KANGXI RADICAL FUR
2F52      ; [.B5AA.0020.0004] # KANGXI RADICAL CLAN
2F53      ; [.AE99.0020.0004] # KANGXI RADICAL STEAM
2F54      ; [.B6BA.0020.0004] # KANGXI RADICAL WATER
328C      ; [.B6BA.0020.0006] # CIRCLED IDEOGRAPH WATER
329F      ; [.CFA5.0020.0006] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.A6DD.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.C445.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.97BC.0020.0004] # KANGXI RADICAL FIRE
328B      ; [.97BC.0020.0006] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.BDE3.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.CCDE.0020.0004] # KANGXI RADICAL CLAW
2F57      ; [.9046.0020.0004] # KANGXI RADICAL FATHER
2F58      ; [.C51B.0020.0004] # KANGXI RADICAL DOUBLE X
2F59      ; [.ABD3.0020.0004] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.AD1C.0020.0004] # KANGXI RADICAL SLICE
2F5B      ; [.C397.0020.0004] # KANGXI RADICAL FANG
2F5C      ; [.AB21.0020.0004] # KANGXI RADICAL COW
3295      ; [.B980.0020.0006] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.B1B4.0020.0004] # KANGXI RADICAL DOG
2F5E      ; [.C2C8.0020.0004] # KANGXI RADICAL PROFOUND
2F5F      ; [.C99A.0020.0004] # KANGXI RADICAL JADE
2F60      ; [.928E.0020.0004] # KANGXI RADICAL MELON
2F61      ; [.BBE5.0020.0004] # KANGXI RADICAL TILE
2F62      ; [.90BE.0020.0004] # KANGXI RADICAL SWEET
2F63      ; [.B523.0020.0004] # KANGXI RADICAL LIFE
1F222     ; [.B523.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.C894.0020.0004] # KANGXI RADICAL USE
2F65      ; [.BA01.0020.0004] # KANGXI RADICAL FIELD
3199      ; [.9955.0020.0014] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.B4C6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.A9E0.0020.0006] # CIRCLED IDEOGRAPH MALE
2F66      ; [.ACE2.0020.0004] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.AA2F.0020.0004] # KANGXI RADICAL SICKNESS
2F68      ; [.83AC.0020.0004] # KANGXI RADICAL DOTTED TENT
2F69      ; [.810B.0020.0004] # KANGXI RADICAL WHITE
2F6A      ; [.ACBB.0020.0004] # KANGXI RADICAL SKIN
2F6B      ; [.A8CF.0020.0004] # KANGXI RADICAL DISH
32AC      ; [.999B.0020.0006] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.A98D.0020.0004] # KANGXI RADICAL EYE
2F6D      ; [.A71E.0020.0004] # KANGXI RADICAL SPEAR
2F6E      ; [.B59D.0020.0004] # KANGXI RADICAL ARROW
2F6F      ; [.B57D.0020.0004] # KANGXI RADICAL STONE
2F70      ; [.B5B0.0020.0004] # KANGXI RADICAL SPIRIT
3293      ; [.B4AC.0020.0006] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.CFAD.0020.0006] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.9BD6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.B2AC.0020.0004] # KANGXI RADICAL TRACK
2F72      ; [.9498.0020.0004] # KANGXI RADICAL GRAIN
3299      ; [.A83C.0020.0006] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.C301.0020.0004] # KANGXI RADICAL CAVE
1F233     ; [.9F18.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.A23B.0020.0004] # KANGXI RADICAL STAND
2F75      ; [.CF74.0020.0004] # KANGXI RADICAL BAMBOO
3247      ; [.CDBB.0020.0006] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.A821.0020.0004] # KANGXI RADICAL RICE
2F77      ; [.A833.0020.0004] # KANGXI RADICAL SILK
1F221     ; [.CEDC.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.8F9E.0020.0004] # KANGXI RADICAL JAR
2F79      ; [.BC56.0020.0004] # KANGXI RADICAL NET
2F7A      ; [.C4C4.0020.0004] # KANGXI RADICAL SHEEP
2F7B      ; [.C975.0020.0004] # KANGXI RADICAL FEATHER
2F7C      ; [.A149.0020.0004] # KANGXI RADICAL OLD
2F7D      ; [.8DE6.0020.0004] # KANGXI RADICAL AND
2F7E      ; [.A19B.0020.0004] # KANGXI RADICAL PLOW
2F7F      ; [.8E00.0020.0004] # KANGXI RADICAL EAR
2F80      ; [.C99D.0020.0004] # KANGXI RADICAL BRUSH
2F81      ; [.B2C1.0020.0004] # KANGXI RADICAL MEAT
2F82      ; [.8612.0020.0004] # KANGXI RADICAL MINISTER
2F83      ; [.D0D4.0020.0004] # KANGXI RADICAL SELF
2F84      ; [.CE51.0020.0004] # KANGXI RADICAL ARRIVE
2F85      ; [.9CA1.0020.0004] # KANGXI RADICAL MORTAR
2F86      ; [.B4A3.0020.0004] # KANGXI RADICAL TONGUE
2F87      ; [.87EF.0020.0004] # KANGXI RADICAL OPPOSE
2F88      ; [.CF09.0020.0004] # KANGXI RADICAL BOAT
2F89      ; [.91A3.0020.0004] # KANGXI RADICAL STOPPING
2F8A      ; [.B3A0.0020.0004] # KANGXI RADICAL COLOR
2F8B      ; [.84B1.0020.0004] # KANGXI RADICAL GRASS
2F8C      ; [.9588.0020.0004] # KANGXI RADICAL TIGER
2F8D      ; [.872E.0020.0004] # KANGXI RADICAL INSECT
2F8E      ; [.C317.0020.0004] # KANGXI RADICAL BLOOD
2F8F      ; [.C1BA.0020.0004] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.C5D3.0020.0004] # KANGXI RADICAL CLOTHES
2F91      ; [.C3B8.0020.0004] # KANGXI RADICAL WEST
2F92      ; [.99FE.0020.0004] # KANGXI RADICAL SEE
2F93      ; [.9AB8.0020.0004] # KANGXI RADICAL HORN
1F216     ; [.9B6C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.C3F5.0020.0004] # KANGXI RADICAL SPEECH
2F95      ; [.924B.0020.0004] # KANGXI RADICAL VALLEY
2F96      ; [.8C5F.0020.0004] # KANGXI RADICAL BEAN
2F97      ; [.B59F.0020.0004] # KANGXI RADICAL PIG
2F98      ; [.CE56.0020.0004] # KANGXI RADICAL BADGER
2F99      ; [.81CA.0020.0004] # KANGXI RADICAL SHELL
3296      ; [.844F.0020.0006] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.8E87.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.D0A3.0020.0006] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.86F6.0020.0004] # KANGXI RADICAL RED
2F9B      ; [.D138.0020.0004] # KANGXI RADICAL RUN
1F230     ; [.D138.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.D141.0020.0004] # KANGXI RADICAL FOOT
2F9D      ; [.B4CA.0020.0004] # KANGXI RADICAL BODY
2F9E      ; [.85ED.0020.0004] # KANGXI RADICAL CART
2F9F      ; [.C17D.0020.0004] # KANGXI RADICAL BITTER
2FA0      ; [.8616.0020.0004] # KANGXI RADICAL MORNING
2FA1      ; [.8858.0020.0004] # KANGXI RADICAL WALK
1F22B     ; [.C8C4.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.B5EC.0020.0006] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.C682.0020.0004] # KANGXI RADICAL CITY
2FA3      ; [.C8D6.0020.0004] # KANGXI RADICAL WINE
2FA4      ; [.82F0.0020.0004] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.A21E.0020.0004] # KANGXI RADICAL VILLAGE
2FA6      ; [.9B96.0020.0004] # KANGXI RADICAL GOLD
328E      ; [.9B96.0020.0006] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.CCB5.0020.0004] # KANGXI RADICAL LONG
2FA8      ; [.A7B4.0020.0004] # KANGXI RADICAL GATE
2FA9      ; [.904E.0020.0004] # KANGXI RADICAL MOUND
2FAA      ; [.A24C.0020.0004] # KANGXI RADICAL SLAVE
2FAB      ; [.D014.0020.0004] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.C976.0020.0004] # KANGXI RADICAL RAIN
2FAD      ; [.B063.0020.0004] # KANGXI RADICAL BLUE
2FAE      ; [.8EB9.0020.0004] # KANGXI RADICAL WRONG
2FAF      ; [.A882.0020.0004] # KANGXI RADICAL FACE
2FB0      ; [.9173.0020.0004] # KANGXI RADICAL LEATHER
2FB1      ; [.BC9A.0020.0004] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.9C9A.0020.0004] # KANGXI RADICAL LEEK
2FB3      ; [.C745.0020.0004] # KANGXI RADICAL SOUND
2FB4      ; [.C59E.0020.0004] # KANGXI RADICAL LEAF
32A0      ; [.C084.0020.0006] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.8F57.0020.0004] # KANGXI RADICAL WIND
2FB6      ; [.8EBA.0020.0004] # KANGXI RADICAL FLY
2FB7      ; [.B58A.0020.0004] # KANGXI RADICAL EAT
2FB8      ; [.B60F.0020.0004] # KANGXI RADICAL HEAD
2FB9      ; [.C044.0020.0004] # KANGXI RADICAL FRAGRANT
2FBA      ; [.A690.0020.0004] # KANGXI RADICAL HORSE
2FBB      ; [.924E.0020.0004] # KANGXI RADICAL BONE
2FBC      ; [.9124.0020.0004] # KANGXI RADICAL TALL
2FBD      ; [.830C.0020.0004] # KANGXI RADICAL HAIR
2FBE      ; [.8C65.0020.0004] # KANGXI RADICAL FIGHT
2FBF      ; [.85BA.0020.0004] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9176.0020.0004] # KANGXI RADICAL CAULDRON
2FC1      ; [.934D.0020.0004] # KANGXI RADICAL GHOST
2FC2      ; [.C936.0020.0004] # KANGXI RADICAL FISH
2FC3      ; [.AABB.0020.0004] # KANGXI RADICAL BIRD
2FC4      ; [.A552.0020.0004] # KANGXI RADICAL SALT
2FC5      ; [.A57C.0020.0004] # KANGXI RADICAL DEER
2FC6      ; [.A6C0.0020.0004] # KANGXI RADICAL WHEAT
2FC7      ; [.A687.0020.0004] # KANGXI RADICAL HEMP
2FC8      ; [.96C2.0020.0004] # KANGXI RADICAL YELLOW
2FC9      ; [.B656.0020.0004] # KANGXI RADICAL MILLET
2FCA      ; [.94F2.0020.0004] # KANGXI RADICAL BLACK
2FCB      ; [.CE4C.0020.0004] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.A87C.0020.0004] # KANGXI RADICAL FROG
2FCD      ; [.8BF6.0020.0004] # KANGXI RADICAL TRIPOD
2FCE      ; [.9261.0020.0004] # KANGXI RADICAL DRUM
2FCF      ; [.B659.0020.0004] # KANGXI RADICAL RAT
2FD0      ; [.8237.0020.0004] # KANGXI RADICAL NOSE
2FD1      ; [.AE64.0020.0004] # KANGXI RADICAL EVEN
2FD2      ; [.86F0.0020.0004] # KANGXI RADICAL TOOTH
2FD3      ; [.A4C6.0020.0004] # KANGXI RADICAL DRAGON
2FD4      ; [.9336.0020.0004] # KANGXI RADICAL TURTLE
2EF3      ; [.9317.0020.0004] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.CAB5.0020.0004] # KANGXI RADICAL FLUTE
F967      ; [.8424.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.839A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.87F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.BC07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.89E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.A23E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F800
2F802     ; [.C5F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F802
F91B      ; [.A613.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.A17A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.A342.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.B4F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
2F819     ; [.837C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F819
F9A8      ; [.A453.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.AA66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F804
FA73      ; [.C1BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA73
F92D      ; [.A084.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.A245.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.BDFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.BDFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.BB64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.82F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.839E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.A624.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F808     ; [.CB31.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F808
2F809     ; [.81DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.C085.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.A356.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.B3C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.B3C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.BE12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.871C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.A86B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.A86B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.BB34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
2F810     ; [.96DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F810
2F814     ; [.AA3E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.B186.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.A338.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.A49F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.9D2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.98F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.CB49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.A744.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.A872.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.B2A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.CA20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.8C16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.9FAC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.9FAC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.A1CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.A329.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.A412.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.A3E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.BEA0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81D     ; [.AF3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.B244.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.AFFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.AFFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.A38C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.A23F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.88A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.9EE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F821     ; [.A65E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F821
2F822     ; [.9162.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.8564.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.A474.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.A237.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.A38D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.A131.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.C87B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.C87B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.A86E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.A86E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.A17D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.A139.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.B039.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.B039.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.A284.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.B486.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.B486.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.8176.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.88AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.81C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.81C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.AA7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.9735.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.81B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.81B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.83E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.9856.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.A610.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.985E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.B068.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.B068.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.B068.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.8464.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.984E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.B77F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.9D21.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.9AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.86F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.C50F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.A23C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.A3EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.BE4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.A5C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.866F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.CF0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F83C     ; [.C009.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83C
2F840     ; [.8D98.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.C468.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F841     ; [.A8A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F841
2F842     ; [.B912.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.AE8E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
FA79      ; [.B968.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F844     ; [.BFC2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.B434.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.B434.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.A06A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.9747.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.9747.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.9494.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.9494.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.86B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
2F849     ; [.CC0F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA0D      ; [.95EF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0D
2F84A     ; [.C52C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84A
FA7B      ; [.BBEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.B8FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.B8FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
2F84E     ; [.9460.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84E
FA38      ; [.AEBB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.AC52.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.A404.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.BB20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F84D     ; [.BB21.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84D
2F855     ; [.C1C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.8675.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.CE0E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.BB35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F854
2F857     ; [.81A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
2F856     ; [.887F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F856
FA39      ; [.AD95.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.CEEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.CEEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.B352.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.A952.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F858     ; [.8B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F858
FA7D      ; [.8F25.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.A1A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.A4EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.D00A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.A6BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.95AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85C     ; [.8F78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.8D1C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.A7F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.C42B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.A9D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.AEA8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.81F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.B49A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.AB5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.AD48.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.9802.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.C92A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.BB66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.826B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.905C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.C83F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.B221.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.888D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.A0ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.A0ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.CC49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.CA24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.CE90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.AB0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.AB0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.AB0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.A35E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.819A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.B611.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.9A4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.C8AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.AAC3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.BB13.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.A5D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.84DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.A5D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.85F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.85F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.AEE6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F879     ; [.C218.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.A629.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
2F87C     ; [.C438.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87C
F921      ; [.A0B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
2F87F     ; [.D096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F87E     ; [.8B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87E
2F880     ; [.8565.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F880
2F9F4     ; [.BE9B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F4
F9AB      ; [.A452.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.C33F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.85D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.C372.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.B6BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.A74C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
2F887     ; [.8F26.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F887
F98E      ; [.AA90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.8CB0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88B     ; [.839D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88B
2F88C     ; [.826C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.B673.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.A2D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.A10D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.A10D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.8093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.A051.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
FA83      ; [.C6DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA83
F982      ; [.A537.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.91E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.AB44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.B94A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.B94A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F874     ; [.8A3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.C1BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.8458.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.8B8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.A5E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
2F89C     ; [.8C26.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89C
F966      ; [.9060.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.C52E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.B23C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.CE53.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.AAAA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
2F89F     ; [.9F9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89F
F960      ; [.AB5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.A2CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.9741.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.CA21.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.972E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.972E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.8CF7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.BC5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.8DAF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.C9CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.A276.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.8883.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.96B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.96B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.B516.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.B516.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA8A      ; [.80BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.9E4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.A500.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.CBF6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.CBF6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.CBF6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.A2E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.8F40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.847C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.C030.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.A7D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.869C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.869C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.869C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.A0EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.A0EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.A324.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.866D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.9945.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.A591.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.89D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B4     ; [.9F3F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B4
2F8B5     ; [.819F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.A05F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.A9AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.B86F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.80E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.AD49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.B600.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.BC1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.9D69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.B4A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.AA99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.B397.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.8DA6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.C433.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.C93D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
2F8C0     ; [.C40D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C0
2F8BD     ; [.9865.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BD
FA8E      ; [.B76C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.9BD4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
FA8F      ; [.8391.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.A914.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
2F8C6     ; [.9AD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C6
2F8C4     ; [.9A82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C4
F991      ; [.AA9F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.9712.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.A55B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.A8D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.A8D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.808D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.9C49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.B682.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.A385.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.A5CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.98C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
2F8CB     ; [.98D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.C689.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.9BCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.B07B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.B07B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.CAC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.B654.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.B654.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
2F8D5     ; [.9BDA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D5
FA06      ; [.81AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.A285.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.91C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.B62E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.D171.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.A11F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.A11F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.A11F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.BC6C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.BC6C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
2F8DA     ; [.D0F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DA
F9E1      ; [.A2BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.8308.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.CCBE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.AE88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.876A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
2F8E0     ; [.97FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.A3B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.A490.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
2F8DF     ; [.92B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DF
F9DA      ; [.A259.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
2F8E5     ; [.81F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E5
2F8E1     ; [.B37D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E1
F97A      ; [.A32A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.A76C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.A76C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
2F8E4     ; [.808A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E4
F9E2      ; [.A1DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E6     ; [.D097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E6
2F8E8     ; [.CC12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8E9     ; [.C536.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E9
2F8EA     ; [.90BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.A176.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.A176.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.A176.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.A504.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
2F8EB     ; [.B4A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EB
F931      ; [.A562.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.CEB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.A0D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.889D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.C249.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.B7FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.A286.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
FA95      ; [.89B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
2F8F4     ; [.BD36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F4
F9A5      ; [.A31E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.B3CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.B3CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.B3CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.AFE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.8E7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
2F8FE     ; [.AEE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FE
F972      ; [.8614.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.C3F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.A837.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
2F8FD     ; [.81F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FD
F9E3      ; [.AA4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
2F8FF     ; [.BDDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FF
F915      ; [.A66A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.8C3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F907     ; [.AD78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F907
2F900     ; [.ABCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.A462.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.A462.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.A462.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.9477.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.A129.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.93D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.93D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.9BCC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.AACC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.A3BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.A1B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.A62B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.C3DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.CF91.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.911B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.C3E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.A45B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.AA85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8B4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.D099.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.D099.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.9618.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
FA98      ; [.C781.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA98
F94E      ; [.A51A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.942D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.942D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.A2D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.85DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.8F27.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.A0FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.A5EF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.C823.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.9C59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.9C59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F913     ; [.CAB7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F917     ; [.AF3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F917
2F835     ; [.96F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F919     ; [.CFEA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F919
2F918     ; [.CB3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.CE5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.B8F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.A39A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.A157.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.8CCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91C
F993      ; [.A318.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.CF92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.CF92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
2F91E     ; [.88BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91E
F9C0      ; [.A366.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.A3CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.A53F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.A0FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.891A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA49      ; [.CCFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA49
FA9E      ; [.9DDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.9DDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
2F922     ; [.CC22.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F922
F946      ; [.A133.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.BE7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
2F925     ; [.81E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F925
FA9F      ; [.8E7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.D00D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.A10A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.CF5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.CF5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.A3AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.B86C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.A5E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.A5E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.BC50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
2F92B     ; [.CA9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92B
F9AD      ; [.A410.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.A66F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.A226.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.A465.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.D199.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92E     ; [.89CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92E
2F92F     ; [.C94D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.C813.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.CD92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.CD92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
2F931     ; [.B84D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F931
F994      ; [.A303.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.A3CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.B0BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA2      ; [.8884.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA2
2F934     ; [.B309.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F934
FAA3      ; [.9628.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.CB3F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.A463.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.8DA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.C6B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.C6B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.A26F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.C98A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA4      ; [.92C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA4
FAA5      ; [.BD3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.A369.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.A0B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.C6A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.C6A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.B546.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.A533.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.CE08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.CE08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.B53E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.CD43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.CD44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.CD44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.CD35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FAA9      ; [.9D8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA9
2F948     ; [.9D8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F948
2F94A     ; [.860C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
FA9D      ; [.AFD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.C1C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.A467.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.A586.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.A586.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.81C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.A1A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
FAAB      ; [.BA14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAB
2F950     ; [.BA14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F950
F964      ; [.ABDF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.A29F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.A21D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.B4AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.AE35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.CE3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.C8F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.D153.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.D153.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.CFAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.B4F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.C062.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.A580.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.97D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.CD54.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.900A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.900A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.A22F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.AA91.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.B64A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.A1CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.9267.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.9267.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95A     ; [.98E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95A
2F95B     ; [.BD69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.BAFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
FAAC      ; [.BA57.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAC
F9F7      ; [.A23B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
2F95F     ; [.AD6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95F
F9F8      ; [.A265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.9B51.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.9B51.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.CFF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.CF80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.A2F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.A4D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
FAAE      ; [.A1B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.A266.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.9C0E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.81EF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.B929.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F969     ; [.B36D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F969
F97B      ; [.A335.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F968     ; [.9A87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F968
2F96A     ; [.98C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.AB29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.B844.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.A1B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.B94E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.8211.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.A5E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.A432.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.D0A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.A31B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.A31B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.A31B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
2F96F     ; [.D113.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96F
FA58      ; [.9BE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.A5DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.8E69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.B38F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.AD85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.B657.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.A1FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
2F976     ; [.85DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F976
F90F      ; [.A64E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
2F978     ; [.C504.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F978
F9AF      ; [.A422.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.C975.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.80A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.A149.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.CD23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.CD23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.CD23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.A424.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
2F97D     ; [.AD69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97D
F997      ; [.A2F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.88C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.A4DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.A167.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.A9B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.C9A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F983     ; [.8934.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F983
2F985     ; [.ACD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.A078.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.A3D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.8772.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.C928.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.C928.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.BF1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98C
FA6D      ; [.92D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.A327.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.84B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.84B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.C99E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.AE85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.CDDD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.960B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.8E93.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.C39B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.B328.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.B328.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.9F4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.8519.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.BDDE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.84F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.96AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F9A0     ; [.AD7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A0
2F99A     ; [.B27F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99B     ; [.9B40.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99B
2F99D     ; [.A713.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.A57A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.9CF4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.9E06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.845F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
2F99E     ; [.8B10.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99E
FAB4      ; [.9614.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.A426.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.A673.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.C5A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.CD36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.CD36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.A2D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.AD86.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
2F9A9     ; [.9BB8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A9
F9C2      ; [.A37C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AA     ; [.8966.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AA
2F9AC     ; [.B30B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.A0C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.A3FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.A53C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
FA20      ; [.B110.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA20
F91F      ; [.A0D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.A656.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.AB6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.A555.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.A555.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.9FD0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B6     ; [.BF2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B6
2F9B8     ; [.AEF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B8
2F9B7     ; [.86AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BA     ; [.AD87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BA
2F9B9     ; [.CA2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B9
2F9BC     ; [.8BD5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
2F9BD     ; [.CF66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BD
FAB5      ; [.CACA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB5
2F9BB     ; [.CACA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BB
2F9BE     ; [.88A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BE
F911      ; [.A64D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
2F9C0     ; [.9359.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C0
2F9C1     ; [.C072.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C1
F927      ; [.A07D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.C1BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C3     ; [.D03A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C3
2F9C4     ; [.C5D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.A39F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.A229.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
2F9C6     ; [.A468.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C6
2F9C7     ; [.B6C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C7
F9E8      ; [.A2C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.A661.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
2F9C9     ; [.C444.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C9
FA60      ; [.94E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.AFA2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.A0CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.907C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.99FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.B5D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.B5D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.8692.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.B6D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.B6D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.8BAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.B08C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.A34C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.A63B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.C9F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.C9F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.CF69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.CF69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.AB81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.AB81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.C5BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.C5BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.9BBE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.9BBE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.B608.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.8C98.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.8304.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.8304.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.AE8C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.B59F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.92E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.827C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.A588.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.9963.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.835E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.CC04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.CC04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.90FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.AE8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.99CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.80E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.A589.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
2F9DC     ; [.AD12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DC
F902      ; [.85ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
2F9DE     ; [.B25D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DE
F998      ; [.AAA2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.A632.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.B644.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.B644.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.901F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.A2B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.8885.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.8616.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.8857.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA66
F99A      ; [.A2CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.C6BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.C6BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.86DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.A364.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.A657.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
2F9E2     ; [.AE81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E2
F92C      ; [.A107.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA2E      ; [.A108.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
2F9E3     ; [.AD74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E3
FA26      ; [.8C50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
2F9E4     ; [.D09D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E4
2F9E6     ; [.85D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E6
F919      ; [.A159.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
FAC4      ; [.B778.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC4
F9B7      ; [.A232.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.A21E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.A34A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.9B96.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.A42E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.83E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
FAC5      ; [.C1CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC5
2F9EA     ; [.8395.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.C2BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
2F9E9     ; [.961F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E9
F93F      ; [.A59D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.A31F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EB     ; [.AFA4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EB
2F9EC     ; [.CB58.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EC
2F9EE     ; [.9E42.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.A5BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
2F9F0     ; [.B3FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F0
F9C6      ; [.B2FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.A518.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.9A78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.A418.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.A574.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.CF90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.A4BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.A3C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.A288.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.A28E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
2F9F3     ; [.AEFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F3
F9EA      ; [.A206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.A9EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.A9EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.A430.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.A17E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.CB01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.A5AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.A448.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.9C4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.9C4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FAC9      ; [.8121.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC9
2F9FA     ; [.82B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.C075.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.C075.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
FACB      ; [.8D88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACB
2F9FE     ; [.8D88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FE
2F9FF     ; [.8D88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FF
F9B4      ; [.A451.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
2FA00     ; [.AD6C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA00
FA6A      ; [.AD55.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.AD55.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.A1BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.9806.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8E89.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.B734.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.92D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
2FA04     ; [.8DCB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA04
2FA05     ; [.CACE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA05
2FA06     ; [.8195.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA06
F91A      ; [.A67A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
2FA07     ; [.BB6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA07
F987      ; [.A21A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.CD7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.CD7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.A55A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
2FA0B     ; [.990A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0B
F9F2      ; [.A3DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
2FA0C     ; [.99A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0C
2FA0F     ; [.ACDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0F
FA2D      ; [.94EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.A5B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.A60F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.A57C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.A2A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.A3DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.A687.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.A1FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.CE4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.A86D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA19     ; [.CE04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA19
2FA1A     ; [.A84E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1A
2FA1B     ; [.8F2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1B
2FA1C     ; [.8237.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
FAD8      ; [.8DD6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD8
F9C4      ; [.A4C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.AC0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.9336.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.9336.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.9336.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
