# Generated by default/object.tt
package Paws::IoTAnalytics::TimestampPartition;
  use Moose;
  has AttributeName => (is => 'ro', isa => 'Str', request_name => 'attributeName', traits => ['NameInRequest'], required => 1);
  has TimestampFormat => (is => 'ro', isa => 'Str', request_name => 'timestampFormat', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::TimestampPartition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::TimestampPartition object:

  $service_obj->Method(Att1 => { AttributeName => $value, ..., TimestampFormat => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::TimestampPartition object:

  $result = $service_obj->Method(...);
  $result->Att1->AttributeName

=head1 DESCRIPTION

A partition defined by a timestamp.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AttributeName => Str

The attribute name of the partition defined by a timestamp.


=head2 TimestampFormat => Str

The timestamp format of a partition defined by a timestamp.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

