use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

my $expected = [
 [
  [  1,176,232, 88,135,166, 82,143,128,253, 42,112,162, 79,  2,168, 60],
  [ 36, 90,238, 15, 15,107, 59,188, 12, 47, 94, 40,235, 63,241,201,  7],
  [201, 44, 64, 33, 38,174, 36,148, 86,185,109,190,246,236,101,207,218],
  [  9,123,220,  7,192,250,115, 17, 24,240,118,169,118, 66,137,114,199],
  [ 67,225,185,217,203,173, 90,111, 32,235, 83, 13,173,248, 76, 17,220],
  [141,170, 22, 11,139, 90, 43,253, 72,255,242,171,182,166, 32,234, 29],
  [175,100,184,191,  8, 83,182, 36,111, 74,154, 82,214,211, 16,202,158],
  [165,246,129,197,171, 77,165,185, 57,206,116,240,215,149,239,243,204],
  [181,174,255,208, 50,159,232,  8, 54,248,102,193,252, 34,112,254, 74],
  [234,209, 88,231,181,154, 67,249, 18,164, 51,174, 91,186,181, 21,192],
  [162,246,159,121,163,215, 23,109,180,248,142, 14,250,218, 29,194,199],
  [150,220,139,172, 53,  7, 72,219, 37,166, 79,127,235,178,168, 32,128],
  [ 18,186,207,110, 89,156, 61, 59,187,238, 91, 25, 13,112,185,116, 67],
  [ 34, 63, 88, 86, 53,121, 67,247,157,  6,101,239,127,108,206,164, 79],
  [225,170,160,216, 74,245,128, 10,252,196, 64,192,126,166, 58, 90,239],
  [ 31,208, 95, 40,206, 33,  2, 91, 61,180,198, 67,235,122, 14,152,147],
  [ 24,220,233, 58,227,145,138, 11,101,232,185,137,233,255,157, 37,228],
  [182, 92,172,175, 34,210,185,118,101, 43,135,190,181,248, 86,118,204],
  [240,197,241,157,  0, 70,179,131,209, 37,128,194,115, 44,139,145, 79],
  [110, 50,137,  6, 69, 46,174,111,253,165,234, 79, 75,246, 50,255,251],
  [190, 44,156,247,230,152,247, 38, 53, 61,226, 30, 69,175,  3, 74, 66],
  [171,219,117, 95, 90, 38, 79,105, 60, 53,240, 93,  1,124,230,105, 40],
  [229,198, 70,148, 37,226, 73,243,165, 15, 27, 55, 68, 33,129,228,126],
 ],
 [
  [  7, 18,139, 43, 36, 78, 32,133,236,246,149,150, 59, 23, 96,173,132],
  [161, 75, 26, 86,  2, 77,189, 57,157,184,165,122,153,121, 97,222,219],
  [200, 35,208,159,245,103, 13,150,176, 68, 84,245,140, 11, 41, 78,250],
  [ 97, 40,175,158,116,255,227, 40,128,133, 59,149, 65,  8,211,  3,124],
  [ 76,175,  0, 71, 73,154,126, 69, 54, 57, 76, 95,213, 42, 71, 73,165],
  [169, 31, 91,234,141,232,248, 25, 31, 76, 34,185,157,149,105, 57,217],
  [111,221,192,229,146, 31,139, 31, 41, 79,209,156, 63,235,196, 77,243],
  [ 78,174,196,190,248,181,  8,154, 79, 77, 99, 63,233,224,130, 90, 37],
  [184,228,230, 33,168,237,146,206,142,147, 87, 41, 33,  5, 35,108, 37],
  [ 56,218, 51,130,191,100, 92, 73,215, 43,191, 53, 20,189,101,159,139],
  [223, 99,137,240,224, 17,165,132,107,171,  3, 62,162, 34, 82, 33,210],
  [ 35, 78, 20,117, 37, 90, 52,233,121,207,  2,127, 43, 12, 87, 70,195],
  [207,126, 82,153,213,109,193,226, 86,113, 74, 31, 95, 65,165, 12,146],
  [226,130,206, 84, 60,115,108,240,201,109, 78,190, 76, 79,231,200,244],
  [ 17, 45,  8,214,  6,  7,176, 28,221, 94,159,222,186,248,109, 10, 39],
  [195, 52, 58, 41,179,131,234, 63,234,155,245,149, 63,103,184, 44,223],
  [ 78,205, 79, 26, 80,199,  5, 32,140,201,225,186,167,116,231,183, 30],
  [255,212, 52, 25,243,145,101,177,105, 26,  2, 71, 54,156,  4,223,231],
  [ 25,229, 26,  1, 84,241,202, 92, 81,237,174, 19, 47,166, 95,230,166],
  [156,234,116,235,111, 56, 66, 75, 45,172,228, 65, 62, 28, 68, 73,247],
  [156, 97, 68,160, 33,117,168,243,155,223, 83,212,107,209, 56, 96,218],
  [ 12,186,251,141,165,251,137,129, 63,227,115,143,137, 45,171, 11,136],
  [ 55, 73,134,125,238,248, 46,218,143,205,223, 43,138,188,112, 91, 83],
 ],
 [
  [ 73, 56, 63, 99,164, 91,204, 50,213,230,228,120, 32, 69, 27,119, 77],
  [ 19,101,146,238,205, 14,  7,100,128,230,  6,181,224, 14,246,221,231],
  [ 67, 40,212,115, 26,198,218,251, 13, 73, 65,209,203, 54, 85,  9,165],
  [106,144,136,139,198,182, 58,124,125, 24,  2,217,201,134,112,111, 84],
  [ 56,175,188, 30, 66,207, 65, 37,188,218, 79,143, 84,213, 61,182, 97],
  [ 24,106,194, 39, 33,240, 40,122, 88,117,216, 89,210,  6, 90,184,154],
  [ 81,164, 21,137, 71,247, 12, 56,101,131,132,  8,182, 30,171,218,206],
  [214, 97,115,203,168, 56, 12,168, 27,181, 52,212, 22,  2,103,126,167],
  [164,123,109, 23,113,102,214,253,101, 92, 31,175,130,216,223,198, 90],
  [147, 33,  6,118,239, 59,112, 63,228, 47,203,141,242,240, 96,133, 29],
  [137, 63,243,140,113,206,195,181, 18,225,193,193,207, 63, 76, 15,139],
  [179, 33,123,  3,156,229, 89,241, 35,152,190, 92,237,153, 16,249,151],
  [100,118, 13,176,174, 29,174,148,  9,235,215,211,188,155, 44,136,238],
  [209,219, 78,220, 49,129, 49, 41,247,128, 88,  7, 28,165,170, 93,154],
  [137, 70,129,199,156, 14,199, 88, 57,  0,116, 19,174,198, 91,187,165],
  [ 27,164, 51,201,114, 15,112, 33,144, 64, 50,250,109, 62, 22,204, 26],
  [222, 13, 12,253, 44,173, 61, 42,139,124, 68, 23,171,170, 78,130,  0],
  [ 78, 63,199,226,166, 13,110,251,105,238, 63, 48,175,199,158,174,114],
  [182,123, 51, 60, 53,156, 90,  3,167,138,235,184,200,233,  0,151,222],
  [124,255,187, 24,177, 55,  4,  1,227, 36,211,112, 43, 35,159,219,  4],
  [161,250,122,139,134,252, 26,155,241,167, 15,157,248, 78, 43, 68,143],
  [123, 32,  2, 61,107, 55,136,211,151,198,  5,182,105, 67,129,254,137],
  [110, 18,250,228,103, 40, 89,224, 38,214,136,217, 50, 58,127, 90, 10],
 ],
 [
  [241,157, 45, 32,193,189,185,209, 84, 43,201, 62, 65,158, 47,122, 54],
  [235, 95,226,125,136,116, 25,176,148,199,136,225,134,116,196,245, 46],
  [  4,210,141, 44,158,160, 43,138,226,165,250,156,221, 15,227,212, 57],
  [ 99, 73,171, 30,251, 51, 74,206, 72, 36, 35,139, 67,111, 16,208,235],
  [ 79, 48, 85, 75,132, 37,254,216,204,219, 41,167,236,121,105, 77,165],
  [182, 63,230, 75, 33,204, 24, 86,158, 12,132,167,171,153,146,214,162],
  [146,241, 66,151,145,192, 61,  5, 83,194, 15,230,  9,139, 19,102,224],
  [255,208,214,201, 35, 51,  4,  9,140,205,175,145,116, 86, 34,179,184],
  [ 45,192, 52,203, 62,141, 67,235,238,111, 94,143,124, 65,178,113,127],
  [110,243, 29,220, 45, 63,106,249, 20, 16,200,108, 27,190,209,249,203],
  [171,244, 36,175,136,179, 22,175,214, 83, 49,147, 17,112,254, 56,161],
  [ 68,222,184, 18, 49, 43, 24,150, 77, 29,187, 96,115, 63, 42,223,186],
  [174,108, 91,178,252,138,  5, 90,234,113,252, 53,220,202, 80, 91, 44],
  [ 11,140,  0, 75, 69,204, 72,215,253,239,221,130,150,227, 37,  5,144],
  [153,138,250, 45,166,174,202,183, 30,  5,142,  1,168,175, 32, 85, 97],
  [252, 41,106,130,137,111,161,104, 86, 43, 18,243,199,183,173,204,228],
  [ 86, 10,160,224, 89, 11,200, 43,114,  3,120, 20,125,140,237, 82,126],
  [159,178,100, 33, 48,114, 46,140,230,112,182,187, 31, 34,115, 59,222],
  [254, 13,135,217,244,251,207, 63,181,230,111,113, 52, 55,232, 67,123],
  [186,147,250, 88,188,224,165,228,148,112,  8,116,238,190,173,244,213],
  [175, 86, 67,207,211,104,126, 10,137,137,224,233,242,255, 38,239,209],
  [ 25, 18, 95, 73, 41,  4,137,157, 83, 64, 24,217,194,224, 99,145,127],
  [255, 11,147,127, 26,235,198, 35, 70,173,  9,194, 36,242, 81,109, 61],
 ],
];


my $expected_region = [
 [
  [ 11,139, 90, 43,253, 72,255,242,171],
  [191,  8, 83,182, 36,111, 74,154, 82],
  [197,171, 77,165,185, 57,206,116,240],
  [208, 50,159,232,  8, 54,248,102,193],
  [231,181,154, 67,249, 18,164, 51,174],
  [121,163,215, 23,109,180,248,142, 14],
  [172, 53,  7, 72,219, 37,166, 79,127],
  [110, 89,156, 61, 59,187,238, 91, 25],
  [ 86, 53,121, 67,247,157,  6,101,239],
  [216, 74,245,128, 10,252,196, 64,192],
  [ 40,206, 33,  2, 91, 61,180,198, 67],
  [ 58,227,145,138, 11,101,232,185,137],
 ],
 [
  [234,141,232,248, 25, 31, 76, 34,185],
  [229,146, 31,139, 31, 41, 79,209,156],
  [190,248,181,  8,154, 79, 77, 99, 63],
  [ 33,168,237,146,206,142,147, 87, 41],
  [130,191,100, 92, 73,215, 43,191, 53],
  [240,224, 17,165,132,107,171,  3, 62],
  [117, 37, 90, 52,233,121,207,  2,127],
  [153,213,109,193,226, 86,113, 74, 31],
  [ 84, 60,115,108,240,201,109, 78,190],
  [214,  6,  7,176, 28,221, 94,159,222],
  [ 41,179,131,234, 63,234,155,245,149],
  [ 26, 80,199,  5, 32,140,201,225,186],
 ],
 [
  [ 39, 33,240, 40,122, 88,117,216, 89],
  [137, 71,247, 12, 56,101,131,132,  8],
  [203,168, 56, 12,168, 27,181, 52,212],
  [ 23,113,102,214,253,101, 92, 31,175],
  [118,239, 59,112, 63,228, 47,203,141],
  [140,113,206,195,181, 18,225,193,193],
  [  3,156,229, 89,241, 35,152,190, 92],
  [176,174, 29,174,148,  9,235,215,211],
  [220, 49,129, 49, 41,247,128, 88,  7],
  [199,156, 14,199, 88, 57,  0,116, 19],
  [201,114, 15,112, 33,144, 64, 50,250],
  [253, 44,173, 61, 42,139,124, 68, 23],
 ],
 [
  [ 75, 33,204, 24, 86,158, 12,132,167],
  [151,145,192, 61,  5, 83,194, 15,230],
  [201, 35, 51,  4,  9,140,205,175,145],
  [203, 62,141, 67,235,238,111, 94,143],
  [220, 45, 63,106,249, 20, 16,200,108],
  [175,136,179, 22,175,214, 83, 49,147],
  [ 18, 49, 43, 24,150, 77, 29,187, 96],
  [178,252,138,  5, 90,234,113,252, 53],
  [ 75, 69,204, 72,215,253,239,221,130],
  [ 45,166,174,202,183, 30,  5,142,  1],
  [130,137,111,161,104, 86, 43, 18,243],
  [224, 89, 11,200, 43,114,  3,120, 20],
 ],
];

for my $file (<t/bpp-32/*.*>) {
  my $pimage = PDL::IO::Image->new_from_file($file);
  is($pimage->get_image_type , "BITMAP", "get_image_type: $file");
  is($pimage->get_color_type , "RGBALPHA", "get_color_type: $file");
  is($pimage->get_colors_used,  0, "get_colors_used: $file");
  is($pimage->get_width      , 17, "get_width: $file");
  is($pimage->get_height     , 23, "get_height: $file");
  is($pimage->get_bpp        , 32, "get_bpp: $file");
  my $pix = $pimage->pixels_to_pdl;
  is($pix->info, 'PDL: Byte D [17,23,4]', "info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp|ras|tif|tiff)$/i) {
    is($pix->sum, 199475, "sum: $file");
    delta_ok($pix->unpdl, $expected, "pixels: $file");
  }
  #region
  $pix = $pimage->pixels_to_pdl(3,11,5,16);
  is($pix->info, 'PDL: Byte D [9,12,4]',    "reg.info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp|ras|tif|tiff)$/i) {
    is($pix->sum, 53400,                    "reg.sum: $file");
    delta_ok($pix->unpdl, $expected_region, "reg.pixels: $file");
  }
  $pix = $pimage->pixels_to_pdl(3,-5,5,-6);
  is($pix->info, 'PDL: Byte D [9,12,4]',    "regneg.info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp|ras|tif|tiff)$/i) {
    is($pix->sum, 53400,                    "regneg.sum: $file");
    delta_ok($pix->unpdl, $expected_region, "regneg.pixels: $file");
  }
}

done_testing();