package Net::Async::Spotify::Object::Generated::PlaylistTracksRef;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::PlaylistTracksRef - Package representing Spotify PlaylistTracksRef Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify PlaylistTracksRef Object attributes:

=over 4

=item href

Type:String
Description:A link to the Web API endpoint where full details of the playlist’s tracks can be retrieved.

=item total

Type:Integer
Description:Number of tracks in the playlist.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        href => 'String',
        total => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
