package WWW::SFDC::Role::Exception;
# ABSTRACT: Exception role for WWW::SFDC libraries

use 5.12.0;
use strict;
use warnings;

our $VERSION = '0.33'; # VERSION

use Log::Log4perl ':easy';
use Scalar::Util 'blessed';

use Moo::Role;
use overload '""' => \&_stringify;

has 'message',
    is => 'ro',
    default => 'There was an error in WWW::SFDC';

sub _stringify {
    my ($self) = shift;
    return $self->message;
}

sub throw {
    my $self = shift;
    my $e = blessed $self ? $self : $self->new(@_);

    FATAL $e;
    die $e;
}

1;

__END__

=pod

=head1 NAME

WWW::SFDC::Role::Exception - Exception role for WWW::SFDC libraries

=head1 VERSION

version 0.33

=head1 AUTHOR

Alexander Brett <alexander.brett@sophos.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Sophos Limited.

This is free software, licensed under:

  The MIT (X11) License

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
